<?php

namespace BitApps\PiPro\src\Integrations\Acpt;

use BitApps\Pi\Helpers\Utility;
use BitApps\Pi\src\Flow\NodeInfoProvider;
use BitApps\Pi\src\Interfaces\ActionInterface;

if (!\defined('ABSPATH')) {
    exit;
}


class AcptAction implements ActionInterface
{
    private $nodeInfoProvider;

    public function __construct(NodeInfoProvider $nodeInfoProvider)
    {
        $this->nodeInfoProvider = $nodeInfoProvider;
    }

    public function execute(): array
    {
        $executedNodeAction = $this->executeAcptAction();

        return Utility::formatResponseData(
            $executedNodeAction['status_code'] ?? 200,
            $executedNodeAction['payload'] ?? [],
            $executedNodeAction['response'] ?? []
        );
    }

    private function executeAcptAction()
    {
        $machineSlug = $this->nodeInfoProvider->getMachineSlug();

        $acptService = new AcptServices($this->nodeInfoProvider);

        switch ($machineSlug) {
            case 'createCustomPostType':
                return $acptService->createCustomPostType();

                break;

            case 'getAllPostType':
                return $acptService->getAllPostType();

                break;

            case 'getPostType':
                return $acptService->getPostType();

                break;

            case 'deletePostType':
                return $acptService->deletePostType();

                break;

            case 'deleteAllPostByPostType':
                return $acptService->deleteAllPostByPostType();

                break;

            case 'getAllFieldGroup':
                return $acptService->getAllFieldGroup();

                break;

            case 'getFieldGroupById':
                return $acptService->getFieldGroupByField('id');

                break;

            case 'getFieldGroupByName':
                return $acptService->getFieldGroupByField('groupName');

                break;

            case 'getFieldGroupByMetaBox':
                return $acptService->getFieldGroupByField('boxName');

                break;

            case 'deleteAllFieldGroup':
                return $acptService->deleteAllFieldGroup();

                break;

            case 'deleteFieldGroup':
                return $acptService->deleteFieldGroup();

                break;

            case 'getAllMetaBox':
                return $acptService->getAllMetaBox();

                break;

            case 'getMetaBoxByName':
                return $acptService->getMetaBoxByName();

                break;

            case 'getMetaBoxById':
                return $acptService->getMetaBoxById();

                break;

            case 'deleteMetaBox':
                return $acptService->deleteMetaBox();

                break;

            case 'getAllMetaField':
                return $acptService->getAllMetaField();

                break;

            case 'getMetaFieldsByMetaBox':
                return $acptService->getMetaFieldsByMetaBox();

                break;

            case 'getMetaField':
                return $acptService->getMetaField();

                break;

            case 'deleteMetaField':
                return $acptService->deleteMetaField();

                break;

            case 'getAllAssociatedPostTypesAndTaxonomies':
                return $acptService->getAllAssociatedPostTypesAndTaxonomies();

                break;

            case 'registerTaxonomy':
                return $acptService->registerTaxonomy();

                break;

            case 'getAllTaxonomy':
                return $acptService->getAllTaxonomy();

                break;

            case 'getTaxonomy':
                return $acptService->getTaxonomy();

                break;

            case 'getTaxonomiesSlug':
                return $acptService->getTaxonomiesSlug();

                break;

            case 'associatePostWithTaxonomy':
                return $acptService->associatePostWithTaxonomy();

                break;

            case 'deletePostAssociations':
                return $acptService->deletePostAssociations();

                break;

            case 'deleteTaxonomy':
                return $acptService->deleteTaxonomy();

                break;

            case 'getAllDynamicBlock':
                return $acptService->getAllDynamicBlock();

                break;

            case 'getDynamicBlockById':
                return $acptService->getDynamicBlockById();

                break;

            case 'getDynamicBlockByName':
                return $acptService->getDynamicBlockByName();

                break;

            case 'getDynamicBlockControlsName':
                return $acptService->getDynamicBlockControlsName();

                break;

            case 'deleteDynamicBlock':
                return $acptService->deleteDynamicBlock();

                break;

            case 'getAllForms':
                return $acptService->getAllForms();

                break;

            case 'getFormById':
                return $acptService->getFormById();

                break;

            case 'getFormByName':
                return $acptService->getFormByName();

                break;

            case 'getFormSubmissions':
                return $acptService->getFormSubmissions();

                break;

            case 'deleteForm':
                return $acptService->deleteForm();

                break;
        }
    }
}
