<?php

namespace BitApps\PiPro\src\Integrations\AdvancedCustomFields;

use BitApps\Pi\src\Integrations\HookRegisterInterface;

if (!\defined('ABSPATH')) {
    exit;
}

class AdvancedCustomFieldsHooks implements HookRegisterInterface
{
    public function register(): array
    {
        return [
            'optionsAcfFieldUpdated' => [
                'hook'     => 'acf/save_post',
                'callback' => [AdvancedCustomFieldsTrigger::class, 'optionsAcfFieldUpdated'],
            ],
            'postAcfFieldUpdated' => [
                'hook'          => 'updated_post_meta',
                'callback'      => [AdvancedCustomFieldsTrigger::class, 'postAcfFieldUpdated'],
                'accepted_args' => 4,
            ],
            'userAcfFieldUpdated' => [
                'hook'          => ['updated_user_meta', 'added_user_meta'],
                'callback'      => [AdvancedCustomFieldsTrigger::class, 'userAcfFieldUpdated'],
                'accepted_args' => 4,
            ],
        ];
    }
}
