<?php

namespace BitApps\PiPro\src\Integrations\Breakdance;

// Prevent direct script access
if (!\defined('ABSPATH')) {
    exit;
}

use BitApps\Pi\Services\FlowService;
use BitApps\PiPro\src\Integrations\IntegrationHelper;

final class BreakdanceTrigger
{
    /**
     * Handle Breakdance form submission.
     *
     * @param array $form
     * @param array $settings
     * @param array $extra
     */
    public static function formSubmission($form, $settings, $extra)
    {
        $data = [
            'form'     => $form,
            'settings' => $settings,
            'extra'    => $extra,
        ];

        $flows = FlowService::exists('breakdance', 'formSubmission');

        if (!$flows) {
            return;
        }

        IntegrationHelper::handleFlowForForm($flows, $data);
    }

    /**
     * Initialize Breakdance form action.
     */
    public static function initBreakdanceFormAction()
    {
        if (
            !\function_exists('\Breakdance\Forms\Actions\registerAction')
            || !class_exists('\Breakdance\Forms\Actions\Action')
        ) {
            return;
        }

        \Breakdance\Forms\Actions\registerAction(new BreakdanceFormAction());
    }
}
