<?php

namespace BitApps\PiPro\src\Integrations\BuddyBoss;

use BitApps\Pi\Helpers\Utility;
use BitApps\Pi\src\Flow\NodeInfoProvider;
use BitApps\Pi\src\Interfaces\ActionInterface;
use BitApps\PiPro\src\Integrations\BuddyBoss\helper\BuddyBossHelper;

if (!\defined('ABSPATH')) {
    exit;
}

class BuddyBossAction implements ActionInterface
{
    private $nodeInfoProvider;

    public function __construct(NodeInfoProvider $nodeInfoProvider)
    {
        $this->nodeInfoProvider = $nodeInfoProvider;
    }

    public function execute(): array
    {
        $executedNodeAction = $this->executeBuddyBossAction();

        return Utility::formatResponseData(
            $executedNodeAction['status_code'] ?? 200,
            $executedNodeAction['payload'] ?? [],
            $executedNodeAction['response'] ?? []
        );
    }

    private function executeBuddyBossAction()
    {
        if (!BuddyBossHelper::isPluginInstalled()) {
            return [
                'status_code' => 400,
                'payload'     => [],
                'response'    => __('BuddyBoss plugin is not active.', 'bit-pi'),
            ];
        }

        $buddyBossService = new BuddyBossService($this->nodeInfoProvider);

        $machineSlug = $this->nodeInfoProvider->getMachineSlug();

        if (!method_exists($buddyBossService, $machineSlug)) {
            return [
                'status_code' => 400,
                'payload'     => [],
                'response'    => __('BuddyBoss action not found.', 'bit-pi'),
            ];
        }

        return $buddyBossService->{$machineSlug}();
    }
}
