<?php

namespace BitApps\PiPro\src\Integrations\BuddyBoss;

use BitApps\Pi\src\Integrations\HookRegisterInterface;

if (!\defined('ABSPATH')) {
    exit;
}

class BuddyBossHooks implements HookRegisterInterface
{
    public function register(): array
    {
        return [
            'userCreatesGroup' => [
                'hook'     => 'groups_group_create_complete',
                'callback' => [BuddyBossTrigger::class, 'userCreatesGroup'],
            ],
            'userAcceptsFriendshipRequest' => [
                'hook'          => 'friends_friendship_accepted',
                'callback'      => [BuddyBossTrigger::class, 'userAcceptsFriendshipRequest'],
                'accepted_args' => 4
            ],
            'userAccountActivated' => [
                'hook'     => 'bp_core_activated_user',
                'callback' => [BuddyBossTrigger::class, 'userAccountActivated'],
            ],
            'userGainsFollower' => [
                'hook'     => 'bp_start_following',
                'callback' => [BuddyBossTrigger::class, 'userGainsFollower'],
            ],
            'userJoinsPublicGroup' => [
                'hook'          => 'groups_join_group',
                'callback'      => [BuddyBossTrigger::class, 'userJoinsPublicGroup'],
                'accepted_args' => 2
            ],
            'userJoinsPrivateGroup' => [
                'hook'          => ['groups_membership_accepted', 'groups_accept_invite'],
                'callback'      => [BuddyBossTrigger::class, 'userJoinsPrivateGroup'],
                'accepted_args' => 2
            ],
            'userJoinsSpecificTypeGroup' => [
                'hook'          => 'groups_join_group',
                'callback'      => [BuddyBossTrigger::class, 'userJoinsSpecificTypeGroup'],
                'accepted_args' => 2
            ],
            'userLeavesGroup' => [
                'hook'          => 'groups_leave_group',
                'callback'      => [BuddyBossTrigger::class, 'userLeavesGroup'],
                'accepted_args' => 2
            ],
            'userLeavesPrivateGroup' => [
                'hook'          => ['groups_leave_group', 'groups_remove_member'],
                'callback'      => [BuddyBossTrigger::class, 'userLeavesPrivateGroup'],
                'accepted_args' => 2
            ],
            'userProfileTypeSetToSpecificType' => [
                'hook'          => 'bp_set_member_type',
                'callback'      => [BuddyBossTrigger::class, 'userProfileTypeSetToSpecificType'],
                'accepted_args' => 3
            ],
            'userReceivesPrivateMessage' => [
                'hook'          => 'messages_message_sent',
                'callback'      => [BuddyBossTrigger::class, 'userReceivesPrivateMessage'],
                'accepted_args' => 5
            ],
            'userRequestsAccessPrivateGroup' => [
                'hook'          => 'groups_membership_requested',
                'callback'      => [BuddyBossTrigger::class, 'userRequestsAccessPrivateGroup'],
                'accepted_args' => 3
            ],
            'userSendsFriendshipRequest' => [
                'hook'          => 'friends_friendship_requested',
                'callback'      => [BuddyBossTrigger::class, 'userSendsFriendshipRequest'],
                'accepted_args' => 3
            ],
            'userUpdatesProfile' => [
                'hook'          => 'xprofile_updated_profile',
                'callback'      => [BuddyBossTrigger::class, 'userUpdatesProfile'],
                'accepted_args' => 5
            ]
        ];
    }
}
