<?php

namespace BitApps\PiPro\src\Integrations\ContactFormEmail;

// Prevent direct script access
if (!\defined('ABSPATH')) {
    exit;
}


use BitApps\Pi\Services\FlowService;
use BitApps\PiPro\src\Integrations\IntegrationHelper;

final class ContactFormEmailTrigger
{
    public static function formSubmission($params)
    {
        if (isset($_POST['cp_contactformtoemail_id'])) {
            $params['form_id'] = absint(
                wp_unslash($_POST['cp_contactformtoemail_id'])
            );
        }

        $flows = FlowService::exists('ContactFormEmail', 'formSubmission');

        if (!$flows) {
            return;
        }

        IntegrationHelper::handleFlowForForm($flows, $params);
    }

    private static function isPluginInstalled()
    {
        return class_exists('CP_CFTEMAIL_BaseClass');
    }
}
