<?php

namespace BitApps\PiPro\src\Integrations\Dokan;

// Prevent direct script access
if (!\defined('ABSPATH')) {
    exit;
}


use WeDevs\DokanPro\Modules\Germanized\Helper;

class DokanHelper
{
    private static $vendorEUFields = [
        [
            'name'  => 'company_name',
            'type'  => 'text',
            'label' => 'Company Name',
        ],
        [
            'name'  => 'company_id_number',
            'type'  => 'text',
            'label' => 'Company ID/EUID Number',
        ],
        [
            'name'  => 'vat_number',
            'type'  => 'text',
            'label' => 'VAT/TAX Number',
        ],
        [
            'name'  => 'eu_bank_name',
            'type'  => 'text',
            'label' => 'Name of Bank',
        ],
        [
            'name'  => 'bank_iban',
            'type'  => 'text',
            'label' => 'Bank IBAN',
        ],
    ];

    public static function formatVendorData($vendorId, $data)
    {
        if (empty($vendorId) || empty($data)) {
            return false;
        }

        foreach ($data as $key => $item) {
            if ($key === 'payment') {
                if (!empty($item['bank'])) {
                    foreach ($item['bank'] as $bankKey => $bankItem) {
                        $vendorData[$bankKey] = $bankItem;
                    }
                }

                if (!empty($item['paypal'])) {
                    foreach ($item['paypal'] as $paypalKey => $paypalItem) {
                        $vendorData['paypal_' . $paypalKey] = $paypalItem;
                    }
                }
            } elseif ($key === 'address') {
                foreach ($item as $addrKey => $addrItem) {
                    $vendorData[$addrKey] = $addrItem;
                }
            } elseif ($key === 'social' || $key === '_links' || $key === 'store_open_close') {
                continue;
            } else {
                $vendorData[$key] = \is_array($item) ? implode(',', $item) : $item;
            }
        }

        $enabledEUFields = self::getEnabledVendorEUFields();

        if (!empty($enabledEUFields)) {
            foreach ($enabledEUFields as $euFiled) {
                if ($euFiled['name'] === 'eu_bank_name') {
                    $vendorData[$euFiled['name']] = isset($data['bank_name']) ? $data['bank_name'] : '';
                } else {
                    $vendorData[$euFiled['name']] = isset($data[$euFiled['name']]) ? $data[$euFiled['name']] : '';
                }
            }
        }

        $vendorData['enabled'] = isset($data['enabled']) ? $data['enabled'] : false;
        $vendorData['trusted'] = isset($data['trusted']) ? $data['trusted'] : false;
        $vendorData['featured'] = isset($data['featured']) ? $data['featured'] : false;
        $vendorData['vendor_id'] = $vendorId;

        return $vendorData;
    }

    public static function formatRefundData($refund)
    {
        if (!$refund) {
            return false;
        }

        $orderId = $refund->get_order_id();
        $vendorId = $refund->get_seller_id();
        $order = dokan()->order->get($orderId);
        $vendor = dokan()->vendor->get($vendorId)->to_array();

        if (!$order || empty($vendor)) {
            return false;
        }

        $refundData = [];

        $refundData['refund_id'] = $refund->get_id();
        $refundData['refund_amount'] = $refund->get_refund_amount();
        $refundData['refund_reason'] = $refund->get_refund_reason();
        $refundData['refund_date'] = $refund->get_date();

        $refundData['order_id'] = $order->get_id();
        $refundData['order_status'] = $order->get_status();
        $refundData['order_currency'] = $order->get_currency();
        $refundData['order_subtotal'] = $order->get_subtotal();
        $refundData['order_total'] = $order->get_total();
        $refundData['order_total_tax'] = $order->get_total_tax();
        $refundData['order_payment_method_title'] = $order->get_payment_method_title();
        $refundData['order_transaction_id'] = $order->get_transaction_id();
        $refundData['order_total_refunded'] = $order->get_total_refunded();

        $refundData['vendor_id'] = $vendor['id'];
        $refundData['vendor_store_name'] = $vendor['store_name'];
        $refundData['vendor_shop_url'] = $vendor['shop_url'];
        $refundData['vendor_first_name'] = $vendor['first_name'];
        $refundData['vendor_last_name'] = $vendor['last_name'];
        $refundData['vendor_email'] = $vendor['email'];
        $refundData['vendor_phone'] = $vendor['phone'];

        return $refundData;
    }

    public static function formatUserToVendorData($userId)
    {
        if (empty($userId)) {
            return false;
        }

        $vendor = dokan()->vendor->get($userId)->to_array();

        if (empty($vendor)) {
            return false;
        }

        $userToVendorData['vendor_id'] = $vendor['id'];
        $userToVendorData['vendor_first_name'] = $vendor['first_name'];
        $userToVendorData['vendor_last_name'] = $vendor['last_name'];
        $userToVendorData['store_name'] = $vendor['store_name'];
        $userToVendorData['shop_url'] = $vendor['shop_url'];
        $userToVendorData['vendor_phone'] = $vendor['phone'];

        $enabledEUFields = self::getEnabledVendorEUFields('user-to-vendor');

        if (!empty($enabledEUFields)) {
            foreach ($enabledEUFields as $euFiled) {
                if ($euFiled['name'] === 'eu_bank_name') {
                    $userToVendorData[$euFiled['name']] = isset($vendor['bank_name']) ? $vendor['bank_name'] : '';
                } else {
                    $userToVendorData[$euFiled['name']] = isset($vendor[$euFiled['name']]) ? $vendor[$euFiled['name']] : '';
                }
            }
        }

        return $userToVendorData;
    }

    public static function formatWithdrawRequestData($userId, $amount, $method)
    {
        if (empty($userId) || empty($amount) || empty($method)) {
            return false;
        }

        $vendor = dokan()->vendor->get($userId)->to_array();

        if (empty($vendor)) {
            return false;
        }

        $withdrawRequestData = [];

        $withdrawRequestData['withdraw_amount'] = $amount;
        $withdrawRequestData['withdraw_method'] = $method;
        $withdrawRequestData['vendor_id'] = $vendor['id'];
        $withdrawRequestData['vendor_store_name'] = $vendor['store_name'];
        $withdrawRequestData['vendor_shop_url'] = $vendor['shop_url'];
        $withdrawRequestData['vendor_first_name'] = $vendor['first_name'];
        $withdrawRequestData['vendor_last_name'] = $vendor['last_name'];
        $withdrawRequestData['vendor_email'] = $vendor['email'];
        $withdrawRequestData['vendor_phone'] = $vendor['phone'];

        return $withdrawRequestData;
    }

    private static function getEnabledVendorEUFields($type = null)
    {
        $fields = [];

        if (is_plugin_active('dokan-pro/dokan-pro.php') && dokan_pro()->module->is_active('germanized')) {
            if ($type === 'user-to-vendor' && !Helper::is_enabled_on_registration_form()) {
                return $fields;
            }

            $enabledEUFields = Helper::is_fields_enabled_for_seller();

            foreach ($enabledEUFields as $key => $item) {
                if ($item) {
                    $formatKey = str_replace('dokan_', '', $key);

                    if ($formatKey === 'bank_name') {
                        $formatKey = 'eu_bank_name';
                    }

                    $vendorEnabledEUFieldsKey[] = $formatKey;
                }
            }

            if ($vendorEnabledEUFieldsKey !== []) {
                foreach (self::$vendorEUFields as $vendorEUField) {
                    if (\in_array($vendorEUField['name'], $vendorEnabledEUFieldsKey)) {
                        $fields[] = $vendorEUField;
                    }
                }
            }
        }

        return $fields;
    }
}
