<?php

namespace BitApps\PiPro\src\Integrations\EasyCommerce;

use EasyCommerce\Models\Cart;
use EasyCommerce\Models\Customer;
use EasyCommerce\Models\Product;

// Prevent direct script access
if (!\defined('ABSPATH')) {
    exit;
}


class EasyCommerceHelper
{
    public static function getProductData($id)
    {
        if (empty($id) || !class_exists('\EasyCommerce\Models\Product')) {
            return [];
        }

        $product = new Product($id);

        return [
            'id'                 => $product->get_id() ?? null,
            'title'              => $product->get_title() ?? null,
            'slug'               => $product->get_slug() ?? null,
            'description'        => $product->get_description() ?? null,
            'summary'            => $product->get_summary() ?? null,
            'status'             => $product->get_status() ?? null,
            'thumbnail'          => $product->get_thumbnail() ?? null,
            'url'                => $product->get_url() ?? null,
            'gallery'            => $product->get_gallery() ?? null,
            'attributes'         => $product->get_attributes() ?? null,
            'rating'             => $product->get_rating() ?? null,
            'sales'              => $product->get_sales() ?? null,
            'prices'             => $product->get_prices() ?? null,
            'prices_is_variable' => $product->is_variable() ?? null,
            'price'              => $product->get_price() ?? null,
            'sale_price'         => $product->get_sale_price() ?? null,
            'stock'              => $product->get_stock() ?? null,
            'has_variations'     => $product->has_variations() ?? null,
            'variations'         => $product->get_variations() ?? null,
            'downloads'          => $product->get_downloads() ?? null,
            'categories'         => $product->get_categories() ?? null,
            'brands'             => $product->get_brands() ?? null,
            'terms'              => $product->get_terms() ?? null,
            'meta_data'          => $product->get_meta() ?? null,
            'created_at'         => $product->get_created_at() ?? null,
            'updated_at'         => $product->get_updated_at() ?? null,
        ];
    }

    public static function getRequestData($request)
    {
        return [
            'all'     => $request->get_params() ?? [],
            'query'   => $request->get_query_params() ?? [],
            'body'    => $request->get_body_params() ?? [],
            'json'    => $request->get_json_params() ?? [],
            'files'   => $request->get_file_params() ?? [],
            'route'   => $request->get_url_params() ?? [],
            'headers' => $request->get_headers() ?? [],
        ];
    }

    public static function getCouponData($coupon)
    {
        return [
            'id'            => $coupon->get_id(),
            'name'          => $coupon->get_name(),
            'code'          => $coupon->get_code(),
            'discount_type' => $coupon->get_discount_type(),
            'amount'        => $coupon->get_amount(),
            'active'        => $coupon->is_active(),
            'rules'         => $coupon->get_rules(true),
        ];
    }

    public static function getOrderData($order)
    {
        $data = [
            'id'                 => $order->get_id() ?? null,
            'customer_id'        => $order->get_customer_id() ?? null,
            'total'              => $order->get_total() ?? null,
            'subtotal'           => $order->get_subtotal() ?? null,
            'tax_total'          => $order->get_tax_total() ?? null,
            'shipping_total'     => $order->get_shipping_total() ?? null,
            'discount_total'     => $order->get_discount_total() ?? null,
            'status'             => $order->get_status() ?? null,
            'fulfillment_status' => $order->get_fulfillment_status() ?? null,
            'payment_method'     => $order->get_payment_method() ?? null,
            'transactions'       => $order->get_transactions(true) ?? null,
            'items'              => $order->get_items(true) ?? null,
            'created_at'         => $order->get_created_at() ?? null,
            'updated_at'         => $order->get_updated_at() ?? null,
        ];

        $data['customer'] = self::getCustomerData($data['customer_id']);

        return $data;
    }

    public static function getCustomerData($customerId)
    {
        if (!class_exists('\EasyCommerce\Models\Customer') || empty($customerId)) {
            return [];
        }

        $customer = new Customer($customerId);

        return [
            'id'         => $customer->get_id(),
            'photo'      => $customer->get_photo(),
            'first_name' => $customer->get_first_name(),
            'last_name'  => $customer->get_last_name(),
            'name'       => $customer->get_first_name() . ' ' . $customer->get_last_name(),
            'email'      => $customer->get_email(),
            'since'      => $customer->get_join_date(),
            'aov'        => $customer->get_aov(),
            'ltv'        => $customer->get_ltv(),
            'count'      => $customer->get_order_count(),
            'billing'    => $customer->get_billing_address(),
            'shipping'   => $customer->get_shipping_address(),
            'last_order' => $customer->get_last_order_date(),
        ];
    }

    public static function prepareAbandonedCartData($hash, $request, $isDeleted = false)
    {
        $data = [
            'hash'    => $hash,
            'request' => EasyCommerceHelper::getRequestData($request),
        ];

        if ($isDeleted) {
            $data['is_deleted'] = $isDeleted;
        }

        if (class_exists('\EasyCommerce\Models\Cart')) {
            $cart = new Cart($hash);

            $data['cart'] = $cart->get() ?? [];
            $data['customer'] = $cart->get_customer() ?? [];
        }

        return $data;
    }
}
