<?php

namespace BitApps\PiPro\src\Integrations\EasyCommerce;

use BitApps\Pi\src\Integrations\HookRegisterInterface;

if (!\defined('ABSPATH')) {
    exit;
}

class EasyCommerceHooks implements HookRegisterInterface
{
    public function register(): array
    {
        return [
            'userCreated' => [
                'hook'          => 'easycommerce_user_created',
                'callback'      => [EasyCommerceTrigger::class, 'userCreated'],
                'priority'      => 10,
                'accepted_args' => 2,
            ],
            'userUpdated' => [
                'hook'          => 'easycommerce_user_updated',
                'callback'      => [EasyCommerceTrigger::class, 'userUpdated'],
                'priority'      => 10,
                'accepted_args' => 2,
            ],
            'attributeCreated' => [
                'hook'          => 'easycommerce_attribute_added',
                'callback'      => [EasyCommerceTrigger::class, 'attributeCreated'],
                'priority'      => 10,
                'accepted_args' => 1,
            ],
            'addToCart' => [
                'hook'          => 'easycommerce_add_to_cart',
                'callback'      => [EasyCommerceTrigger::class, 'addToCart'],
                'priority'      => 10,
                'accepted_args' => 1,
            ],
            'cartUpdated' => [
                'hook'          => 'easycommerce_update_cart',
                'callback'      => [EasyCommerceTrigger::class, 'cartUpdated'],
                'priority'      => 10,
                'accepted_args' => 3,
            ],
            'productRemoveFromCart' => [
                'hook'          => 'easycommerce_remove_from_cart',
                'callback'      => [EasyCommerceTrigger::class, 'productRemoveFromCart'],
                'priority'      => 10,
                'accepted_args' => 1,
            ],
            'cartCleared' => [
                'hook'          => 'easycommerce_clear_cart',
                'callback'      => [EasyCommerceTrigger::class, 'cartCleared'],
                'priority'      => 10,
                'accepted_args' => 1,
            ],
            'setCheckoutShippingMethod' => [
                'hook'          => 'easycommerce_set_shipping_method',
                'callback'      => [EasyCommerceTrigger::class, 'setCheckoutShippingMethod'],
                'priority'      => 10,
                'accepted_args' => 1,
            ],
            'couponApplied' => [
                'hook'          => 'easycommerce_apply_coupon',
                'callback'      => [EasyCommerceTrigger::class, 'couponApplied'],
                'priority'      => 10,
                'accepted_args' => 1,
            ],
            'couponRemovedFromCheckoutPage' => [
                'hook'          => 'easycommerce_remove_coupon',
                'callback'      => [EasyCommerceTrigger::class, 'couponRemovedFromCheckoutPage'],
                'priority'      => 10,
                'accepted_args' => 2,
            ],
            'couponStatusUpdated' => [
                'hook'          => 'easycommerce_coupon_status_updated',
                'callback'      => [EasyCommerceTrigger::class, 'couponStatusUpdated'],
                'priority'      => 10,
                'accepted_args' => 3,
            ],
            'couponDeleted' => [
                'hook'          => 'easycommerce_before_delete_coupon',
                'callback'      => [EasyCommerceTrigger::class, 'couponDeleted'],
                'priority'      => 10,
                'accepted_args' => 1,
            ],
            'orderCreated' => [
                'hook'          => 'easycommerce_after_create_order',
                'callback'      => [EasyCommerceTrigger::class, 'orderCreated'],
                'priority'      => 10,
                'accepted_args' => 3,
            ],
            'orderStatusUpdated' => [
                'hook'          => 'easycommerce_order_status_updated',
                'callback'      => [EasyCommerceTrigger::class, 'orderStatusUpdated'],
                'priority'      => 10,
                'accepted_args' => 3,
            ],
            'orderRefunded' => [
                'hook'          => 'easycommerce_after_refund_order',
                'callback'      => [EasyCommerceTrigger::class, 'orderRefunded'],
                'priority'      => 10,
                'accepted_args' => 2,
            ],
            'emailToCustomer' => [
                'hook'          => 'easycommerce_email',
                'callback'      => [EasyCommerceTrigger::class, 'emailToCustomer'],
                'priority'      => 10,
                'accepted_args' => 4,
            ],
            'setOrderStatusToProcessing' => [
                'hook'          => 'easycommerce_order_status_updated',
                'callback'      => [EasyCommerceTrigger::class, 'setOrderStatusToProcessing'],
                'priority'      => 10,
                'accepted_args' => 3,
            ],
            'setOrderStatusToCompleted' => [
                'hook'          => 'easycommerce_order_status_updated',
                'callback'      => [EasyCommerceTrigger::class, 'setOrderStatusToCompleted'],
                'priority'      => 10,
                'accepted_args' => 3,
            ],
            'setOrderStatusToPending' => [
                'hook'          => 'easycommerce_order_status_updated',
                'callback'      => [EasyCommerceTrigger::class, 'setOrderStatusToPending'],
                'priority'      => 10,
                'accepted_args' => 3,
            ],
            'setOrderStatusToRefunded' => [
                'hook'          => 'easycommerce_order_status_updated',
                'callback'      => [EasyCommerceTrigger::class, 'setOrderStatusToRefunded'],
                'priority'      => 10,
                'accepted_args' => 3,
            ],
            'setOrderStatusToOnHold' => [
                'hook'          => 'easycommerce_order_status_updated',
                'callback'      => [EasyCommerceTrigger::class, 'setOrderStatusToOnHold'],
                'priority'      => 10,
                'accepted_args' => 3,
            ],
            'setOrderStatusToCancelled' => [
                'hook'          => 'easycommerce_order_status_updated',
                'callback'      => [EasyCommerceTrigger::class, 'setOrderStatusToCancelled'],
                'priority'      => 10,
                'accepted_args' => 3,
            ],
            'productCreated' => [
                'hook'          => 'easycommerce_create_product',
                'callback'      => [EasyCommerceTrigger::class, 'productCreated'],
                'priority'      => 10,
                'accepted_args' => 1,
            ],
            'productUpdated' => [
                'hook'          => 'easycommerce_update_product',
                'callback'      => [EasyCommerceTrigger::class, 'productUpdated'],
                'priority'      => 10,
                'accepted_args' => 1,
            ],
            'productDeleted' => [
                'hook'          => 'easycommerce_before_delete_product',
                'callback'      => [EasyCommerceTrigger::class, 'productDeleted'],
                'priority'      => 10,
                'accepted_args' => 1,
            ],
            'productStatusUpdated' => [
                'hook'          => 'easycommerce_update_product_email',
                'callback'      => [EasyCommerceTrigger::class, 'productStatusUpdated'],
                'priority'      => 10,
                'accepted_args' => 2,
            ],
            'setProductStatusToLive' => [
                'hook'          => 'easycommerce_update_product_email',
                'callback'      => [EasyCommerceTrigger::class, 'setProductStatusToLive'],
                'priority'      => 10,
                'accepted_args' => 2,
            ],
            'setProductStatusToDraft' => [
                'hook'          => 'easycommerce_update_product_email',
                'callback'      => [EasyCommerceTrigger::class, 'setProductStatusToDraft'],
                'priority'      => 10,
                'accepted_args' => 2,
            ],
            'setProductStatusToTrash' => [
                'hook'          => 'easycommerce_update_product_email',
                'callback'      => [EasyCommerceTrigger::class, 'setProductStatusToTrash'],
                'priority'      => 10,
                'accepted_args' => 2,
            ],
            'abandonedCartDeleted' => [
                'hook'          => 'easycommerce_after_remove_abandoned',
                'callback'      => [EasyCommerceTrigger::class, 'abandonedCartDeleted'],
                'priority'      => 10,
                'accepted_args' => 3,
            ],
            'abandonedCartReminderSent' => [
                'hook'          => 'easycommerce_before_send_abandoned_reminder',
                'callback'      => [EasyCommerceTrigger::class, 'abandonedCartReminderSent'],
                'priority'      => 10,
                'accepted_args' => 2,
            ],
        ];
    }
}
