<?php

namespace BitApps\PiPro\src\Integrations\EssentialAddonsElementor;

use BitApps\Pi\src\Integrations\HookRegisterInterface;

if (!\defined('ABSPATH')) {
    exit;
}

class EssentialAddonsElementorHooks implements HookRegisterInterface
{
    public function register(): array
    {
        return [
            'userLogin' => [
                'hook'          => 'eael/login-register/after-login',
                'callback'      => [EssentialAddonsElementorTrigger::class, 'userLogin'],
                'accepted_args' => 2,
            ],
            'userRegistration' => [
                'hook'          => 'eael/login-register/after-insert-user',
                'callback'      => [EssentialAddonsElementorTrigger::class, 'userRegistration'],
                'accepted_args' => 2,
            ],
        ];
    }
}
