<?php

namespace BitApps\PiPro\src\Integrations\Flowlu;

use BitApps\Pi\Deps\BitApps\WPKit\Helpers\JSON;
use BitApps\Pi\Helpers\MixInputHandler;
use BitApps\Pi\src\Flow\NodeInfoProvider;

if (!\defined('ABSPATH')) {
    exit;
}

final class FlowluAccountTypeService
{
    private $http;

    private $baseUrl;

    private NodeInfoProvider $nodeInfoProvider;

    public function __construct($httpClient, $baseUrl, NodeInfoProvider $nodeInfoProvider)
    {
        $this->http = $httpClient;
        $this->baseUrl = $baseUrl;
        $this->nodeInfoProvider = $nodeInfoProvider;
    }

    public function createAccountType()
    {
        $name = MixInputHandler::replaceMixTagValue($this->nodeInfoProvider->getFieldMapConfigs('name.value'));

        $data = [];
        if (!empty($name)) {
            $data['name'] = $name;
        }

        try {
            $response = $this->http->request(
                $this->baseUrl . '/module/crm/account_category/create',
                'POST',
                JSON::encode($data),
                []
            );

            $responseCode = $this->http->getResponseCode();
            $success = $responseCode >= 200 && $responseCode < 300;

            return [
                'response'    => $response,
                'payload'     => $data,
                'status_code' => $responseCode,
                'success'     => $success
            ];
        } catch (\Exception $e) {
            return [
                'response'    => [
                    'success' => false,
                    'message' => 'Failed to create account type: ' . $e->getMessage()
                ],
                'payload'     => $data,
                'status_code' => 500,
                'success'     => false
            ];
        }
    }

    public function updateAccountType()
    {
        $accountTypeId = MixInputHandler::replaceMixTagValue($this->nodeInfoProvider->getFieldMapConfigs('account-type-id.value'));
        $name = MixInputHandler::replaceMixTagValue($this->nodeInfoProvider->getFieldMapConfigs('name.value'));

        if (empty($accountTypeId)) {
            return [
                'response'    => [
                    'success' => false,
                    'message' => 'Account type ID is required for update'
                ],
                'payload'     => [],
                'status_code' => 400,
                'success'     => false
            ];
        }
        $data = [];
        if (!empty($name)) {
            $data['name'] = $name;
        }

        try {
            $response = $this->http->request(
                $this->baseUrl . "/module/crm/account_category/update/{$accountTypeId}",
                'POST',
                JSON::encode($data),
                []
            );

            $responseCode = $this->http->getResponseCode();
            $success = $responseCode >= 200 && $responseCode < 300;

            return [
                'response'    => $response,
                'payload'     => $data,
                'status_code' => $responseCode,
                'success'     => $success
            ];
        } catch (\Exception $e) {
            return [
                'response'    => [
                    'success' => false,
                    'message' => 'Failed to update account type: ' . $e->getMessage()
                ],
                'payload'     => $data,
                'status_code' => 500,
                'success'     => false
            ];
        }
    }

    public function getAccountType()
    {
        $accountTypeId = MixInputHandler::replaceMixTagValue($this->nodeInfoProvider->getFieldMapConfigs('account-type-id.value'));

        if (empty($accountTypeId)) {
            return [
                'response'    => [
                    'success' => false,
                    'message' => 'Account type ID is required for get'
                ],
                'payload'     => [],
                'status_code' => 400,
                'success'     => false
            ];
        }
        try {
            $response = $this->http->request(
                $this->baseUrl . "/module/crm/account_category/get/{$accountTypeId}",
                'GET',
                [],
                []
            );

            $responseCode = $this->http->getResponseCode();
            $success = $responseCode >= 200 && $responseCode < 300;

            return [
                'response'    => $response,
                'payload'     => ['account_type_id' => $accountTypeId],
                'status_code' => $responseCode,
                'success'     => $success
            ];
        } catch (\Exception $e) {
            return [
                'response'    => [
                    'success' => false,
                    'message' => 'Failed to get account type: ' . $e->getMessage()
                ],
                'payload'     => ['account_type_id' => $accountTypeId],
                'status_code' => 500,
                'success'     => false
            ];
        }
    }

    public function listAccountTypes()
    {
        try {
            $response = $this->http->request(
                $this->baseUrl . '/module/crm/account_category/list',
                'GET',
                [],
                []
            );

            $responseCode = $this->http->getResponseCode();
            $success = $responseCode >= 200 && $responseCode < 300;

            return [
                'response'    => $response,
                'payload'     => [],
                'status_code' => $responseCode,
                'success'     => $success
            ];
        } catch (\Exception $e) {
            return [
                'response'    => [
                    'success' => false,
                    'message' => 'Failed to list account types: ' . $e->getMessage()
                ],
                'payload'     => [],
                'status_code' => 500,
                'success'     => false
            ];
        }
    }

    public function deleteAccountType()
    {
        $accountTypeId = MixInputHandler::replaceMixTagValue($this->nodeInfoProvider->getFieldMapConfigs('account-type-id.value'));
        if (empty($accountTypeId)) {
            return [
                'response'    => [
                    'success' => false,
                    'message' => 'Account type ID is required for delete'
                ],
                'payload'     => [],
                'status_code' => 400,
                'success'     => false
            ];
        }
        try {
            $response = $this->http->request(
                $this->baseUrl . "/module/crm/account_category/delete/{$accountTypeId}",
                'GET',
                [],
                []
            );

            $responseCode = $this->http->getResponseCode();
            $success = $responseCode >= 200 && $responseCode < 300;

            return [
                'response'    => $response,
                'payload'     => ['account_type_id' => $accountTypeId],
                'status_code' => $responseCode,
                'success'     => $success
            ];
        } catch (\Exception $e) {
            return [
                'response'    => [
                    'success' => false,
                    'message' => 'Failed to delete account type: ' . $e->getMessage()
                ],
                'payload'     => ['account_type_id' => $accountTypeId],
                'status_code' => 500,
                'success'     => false
            ];
        }
    }
}
