<?php

namespace BitApps\PiPro\src\Integrations\Flowlu;

use BitApps\Pi\Deps\BitApps\WPKit\Helpers\JSON;
use BitApps\Pi\Helpers\MixInputHandler;
use BitApps\Pi\src\Flow\NodeInfoProvider;

if (!\defined('ABSPATH')) {
    exit;
}

final class FlowluCalendarService
{
    private $http;

    private $baseUrl;

    private NodeInfoProvider $nodeInfoProvider;

    public function __construct($httpClient, $baseUrl, NodeInfoProvider $nodeInfoProvider)
    {
        $this->http = $httpClient;
        $this->baseUrl = $baseUrl;
        $this->nodeInfoProvider = $nodeInfoProvider;
    }

    public function createCalendar()
    {
        $name = MixInputHandler::replaceMixTagValue($this->nodeInfoProvider->getFieldMapConfigs('name.value'));

        $data = [];
        if (!empty($name)) {
            $data['name'] = $name;
        }

        try {
            $response = $this->http->request(
                $this->baseUrl . '/module/calendar/calendar/create',
                'POST',
                JSON::encode($data),
                []
            );

            $responseCode = $this->http->getResponseCode();
            $success = $responseCode >= 200 && $responseCode < 300;

            return [
                'response'    => $response,
                'payload'     => $data,
                'status_code' => $responseCode,
                'success'     => $success
            ];
        } catch (\Exception $e) {
            return [
                'response'    => [
                    'success' => false,
                    'message' => 'Failed to create calendar: ' . $e->getMessage()
                ],
                'payload'     => $data,
                'status_code' => 500,
                'success'     => false
            ];
        }
    }

    public function updateCalendar()
    {
        $calendarId = MixInputHandler::replaceMixTagValue($this->nodeInfoProvider->getFieldMapConfigs('calendar-id.value'));
        $name = MixInputHandler::replaceMixTagValue($this->nodeInfoProvider->getFieldMapConfigs('name.value'));

        if (empty($calendarId)) {
            return [
                'response'    => [
                    'success' => false,
                    'message' => 'Calendar ID is required to update calendar'
                ],
                'payload'     => [],
                'status_code' => 400,
                'success'     => false
            ];
        }
        $data = [];
        if (!empty($name)) {
            $data['name'] = $name;
        }

        try {
            $response = $this->http->request(
                $this->baseUrl . "/module/calendar/calendar/update/{$calendarId}",
                'POST',
                JSON::encode($data),
                []
            );

            $responseCode = $this->http->getResponseCode();
            $success = $responseCode >= 200 && $responseCode < 300;

            return [
                'response'    => $response,
                'payload'     => $data,
                'status_code' => $responseCode,
                'success'     => $success
            ];
        } catch (\Exception $e) {
            return [
                'response'    => [
                    'success' => false,
                    'message' => 'Failed to update calendar: ' . $e->getMessage()
                ],
                'payload'     => $data,
                'status_code' => 500,
                'success'     => false
            ];
        }
    }

    public function getCalendar()
    {
        $calendarId = MixInputHandler::replaceMixTagValue($this->nodeInfoProvider->getFieldMapConfigs('calendar-id.value'));

        if (empty($calendarId)) {
            return [
                'response'    => [
                    'success' => false,
                    'message' => 'Calendar ID is required to get calendar'
                ],
                'payload'     => [],
                'status_code' => 400,
                'success'     => false
            ];
        }
        try {
            $response = $this->http->request(
                $this->baseUrl . "/module/calendar/calendar/get/{$calendarId}",
                'GET',
                [],
                []
            );

            $responseCode = $this->http->getResponseCode();
            $success = $responseCode >= 200 && $responseCode < 300;

            return [
                'response'    => $response,
                'payload'     => ['calendar_id' => $calendarId],
                'status_code' => $responseCode,
                'success'     => $success
            ];
        } catch (\Exception $e) {
            return [
                'response'    => [
                    'success' => false,
                    'message' => 'Failed to get calendar: ' . $e->getMessage()
                ],
                'payload'     => ['calendar_id' => $calendarId],
                'status_code' => 500,
                'success'     => false
            ];
        }
    }

    public function listCalendars()
    {
        try {
            $response = $this->http->request(
                $this->baseUrl . '/module/calendar/calendar/list',
                'GET',
                [],
                []
            );

            $responseCode = $this->http->getResponseCode();
            $success = $responseCode >= 200 && $responseCode < 300;

            return [
                'response'    => $response,
                'payload'     => [],
                'status_code' => $responseCode,
                'success'     => $success
            ];
        } catch (\Exception $e) {
            return [
                'response'    => [
                    'success' => false,
                    'message' => 'Failed to list calendars: ' . $e->getMessage()
                ],
                'payload'     => [],
                'status_code' => 500,
                'success'     => false
            ];
        }
    }

    public function deleteCalendar()
    {
        $calendarId = MixInputHandler::replaceMixTagValue($this->nodeInfoProvider->getFieldMapConfigs('calendar-id.value'));

        if (empty($calendarId)) {
            return [
                'response'    => [
                    'success' => false,
                    'message' => 'Calendar ID is required to delete calendar'
                ],
                'payload'     => [],
                'status_code' => 400,
                'success'     => false
            ];
        }
        try {
            $response = $this->http->request(
                $this->baseUrl . "/module/calendar/calendar/delete/{$calendarId}",
                'GET',
                [],
                []
            );

            $responseCode = $this->http->getResponseCode();
            $success = $responseCode >= 200 && $responseCode < 300;

            return [
                'response'    => $response,
                'payload'     => ['calendar_id' => $calendarId],
                'status_code' => $responseCode,
                'success'     => $success
            ];
        } catch (\Exception $e) {
            return [
                'response'    => [
                    'success' => false,
                    'message' => 'Failed to delete calendar: ' . $e->getMessage()
                ],
                'payload'     => ['calendar_id' => $calendarId],
                'status_code' => 500,
                'success'     => false
            ];
        }
    }
}
