<?php

namespace BitApps\PiPro\src\Integrations\FluentAffiliate;

use BitApps\Pi\src\Integrations\HookRegisterInterface;

if (!\defined('ABSPATH')) {
    exit;
}

class FluentAffiliateHooks implements HookRegisterInterface
{
    public function register(): array
    {
        return [
            'affiliateCreated' => [
                'hook'          => 'fluent_affiliate/affiliate_created',
                'callback'      => [FluentAffiliateTrigger::class, 'affiliateCreated'],
                'priority'      => 10,
                'accepted_args' => 1,
            ],
            'affiliateUpdated' => [
                'hook'          => 'fluent_affiliate/affiliate_updated',
                'callback'      => [FluentAffiliateTrigger::class, 'affiliateUpdated'],
                'priority'      => 10,
                'accepted_args' => 3,
            ],
            'affiliateApproved' => [
                'hook'          => 'fluent_affiliate/affiliate_status_to_active',
                'callback'      => [FluentAffiliateTrigger::class, 'affiliateApproved'],
                'priority'      => 10,
                'accepted_args' => 1,
            ],
            'affiliatePending' => [
                'hook'          => 'fluent_affiliate/affiliate_status_to_pending',
                'callback'      => [FluentAffiliateTrigger::class, 'affiliatePending'],
                'priority'      => 10,
                'accepted_args' => 2,
            ],
            'affiliateInactivate' => [
                'hook'          => 'fluent_affiliate/affiliate_status_to_inactive',
                'callback'      => [FluentAffiliateTrigger::class, 'affiliateInactivate'],
                'priority'      => 10,
                'accepted_args' => 2,
            ],
            'affiliateDeleted' => [
                'hook'          => 'fluent_affiliate/before_delete_affiliate',
                'callback'      => [FluentAffiliateTrigger::class, 'affiliateDeleted'],
                'priority'      => 10,
                'accepted_args' => 1,
            ],
            'referralCreated' => [
                'hook'          => 'fluent_affiliate/referral_marked_unpaid',
                'callback'      => [FluentAffiliateTrigger::class, 'referralCreated'],
                'priority'      => 10,
                'accepted_args' => 1,
            ],
            'referralDeleted' => [
                'hook'          => 'fluent_affiliate/referral/before_delete',
                'callback'      => [FluentAffiliateTrigger::class, 'referralDeleted'],
                'priority'      => 10,
                'accepted_args' => 1,
            ],
        ];
    }
}
