<?php

namespace BitApps\PiPro\src\Integrations\FluentBoards;

use BitApps\Pi\Helpers\Utility;
use BitApps\Pi\src\Flow\NodeInfoProvider;
use BitApps\Pi\src\Interfaces\ActionInterface;

if (!\defined('ABSPATH')) {
    exit;
}


class FluentBoardsAction implements ActionInterface
{
    private $nodeInfoProvider;

    public function __construct(NodeInfoProvider $nodeInfoProvider)
    {
        $this->nodeInfoProvider = $nodeInfoProvider;
    }

    public function execute(): array
    {
        $executedNodeAction = $this->executeFluentBoardsAction();

        return Utility::formatResponseData(
            $executedNodeAction['status_code'] ?? 200,
            $executedNodeAction['payload'] ?? [],
            $executedNodeAction['response'] ?? []
        );
    }

    private function executeFluentBoardsAction()
    {
        $fluentBoardsServices = new FluentBoardsServices($this->nodeInfoProvider);

        $machineSlug = $this->nodeInfoProvider->getMachineSlug();

        switch ($machineSlug) {
            case 'listAllBoards':
                return $fluentBoardsServices->listAllBoards();

            case 'getSingleBoard':
                return $fluentBoardsServices->getSingleBoard();

            case 'createBoard':
                return $fluentBoardsServices->createBoard();

            case 'updateBoard':
                return $fluentBoardsServices->updateBoard();

            case 'deleteBoard':
                return $fluentBoardsServices->deleteBoard();

            case 'archiveBoard':
                return $fluentBoardsServices->archiveBoard();

            case 'restoreBoard':
                return $fluentBoardsServices->restoreBoard();

            case 'duplicateBoard':
                return $fluentBoardsServices->duplicateBoard();

            case 'getBoardMembers':
                return $fluentBoardsServices->getBoardMembers();

            case 'getBoardActivities':
                return $fluentBoardsServices->getBoardActivities();

            case 'listAllTasks':
                return $fluentBoardsServices->listAllTasks();

            case 'getSingleTask':
                return $fluentBoardsServices->getSingleTask();

            case 'createTask':
                return $fluentBoardsServices->createTask();

            case 'deleteTask':
                return $fluentBoardsServices->deleteTask();

            case 'moveTask':
                return $fluentBoardsServices->moveTask();

            case 'cloneTask':
                return $fluentBoardsServices->cloneTask();

            case 'getTaskComments':
                return $fluentBoardsServices->getTaskComments();

            case 'getTaskActivities':
                return $fluentBoardsServices->getTaskActivities();

            case 'createStage':
                return $fluentBoardsServices->createStage();

            case 'archiveStage':
                return $fluentBoardsServices->archiveStage();

            case 'archiveAllTasksInStage':
                return $fluentBoardsServices->archiveAllTasksInStage();

            case 'restoreStage':
                return $fluentBoardsServices->restoreStage();

            case 'getArchivedStages':
                return $fluentBoardsServices->getArchivedStages();

            case 'getStageTaskAvailablePositions':
                return $fluentBoardsServices->getStageTaskAvailablePositions();

            case 'listAllLabels':
                return $fluentBoardsServices->listAllLabels();

            case 'createLabel':
                return $fluentBoardsServices->createLabel();

            case 'updateLabel':
                return $fluentBoardsServices->updateLabel();

            case 'deleteLabel':
                return $fluentBoardsServices->deleteLabel();

            case 'getLabelsUsedInTasks':
                return $fluentBoardsServices->getLabelsUsedInTasks();

            case 'getTaskLabels':
                return $fluentBoardsServices->getTaskLabels();

            case 'assignLabelsToTask':
                return $fluentBoardsServices->assignLabelsToTask();

            case 'removeLabelFromTask':
                return $fluentBoardsServices->removeLabelFromTask();

            case 'listTaskComments':
                return $fluentBoardsServices->listTaskComments();

            case 'createComment':
                return $fluentBoardsServices->createComment();

            case 'deleteComment':
                return $fluentBoardsServices->deleteComment();

            case 'listSubtasks':
                return $fluentBoardsServices->listSubtasks();

            case 'createSubtask':
                return $fluentBoardsServices->createSubtask();

            case 'createSubtaskGroup':
                return $fluentBoardsServices->createSubtaskGroup();

            case 'deleteSubtask':
                return $fluentBoardsServices->deleteSubtask();

            case 'cloneSubtask':
                return $fluentBoardsServices->cloneSubtask();

            case 'listFolders':
                return $fluentBoardsServices->listFolders();

            case 'createFolder':
                return $fluentBoardsServices->createFolder();

            case 'updateFolder':
                return $fluentBoardsServices->updateFolder();

            case 'deleteFolder':
                return $fluentBoardsServices->deleteFolder();

            case 'addBoardsToFolder':
                return $fluentBoardsServices->addBoardsToFolder();

            case 'removeBoardFromFolder':
                return $fluentBoardsServices->removeBoardFromFolder();

            case 'listAllUsers':
                return $fluentBoardsServices->listAllUsers();

            case 'searchUsers':
                return $fluentBoardsServices->searchUsers();

            case 'getProjectMembers':
                return $fluentBoardsServices->getProjectMembers();

            case 'addMembersToProject':
                return $fluentBoardsServices->addMembersToProject();

            case 'removeUserFromProject':
                return $fluentBoardsServices->removeUserFromProject();

            case 'makeUserManager':
                return $fluentBoardsServices->makeUserManager();

            case 'removeManagerRole':
                return $fluentBoardsServices->removeManagerRole();

            case 'makeUserMember':
                return $fluentBoardsServices->makeUserMember();

            case 'makeUserViewer':
                return $fluentBoardsServices->makeUserViewer();

            case 'removeUserFromBoard':
                return $fluentBoardsServices->removeUserFromBoard();

            case 'getProjectAssignees':
                return $fluentBoardsServices->getProjectAssignees();

            default:
                return [
                    'response'    => __('Invalid machine slug.', 'bit-pi'),
                    'payload'     => [],
                    'status_code' => 400,
                ];
        }
    }
}
