<?php

namespace BitApps\PiPro\src\Integrations\FluentBoards;

use BitApps\Pi\src\Integrations\HookRegisterInterface;

if (!\defined('ABSPATH')) {
    exit;
}

class FluentBoardsHooks implements HookRegisterInterface
{
    public function register(): array
    {
        return [
            'boardCreated' => [
                'hook'     => 'fluent_boards/board_created',
                'callback' => [FluentBoardsTrigger::class, 'boardCreated'],
            ],
            'boardUpdated' => [
                'hook'          => 'fluent_boards/board_updated',
                'callback'      => [FluentBoardsTrigger::class, 'boardUpdated'],
                'accepted_args' => 2,
            ],
            'boardArchived' => [
                'hook'     => 'fluent_boards/board_archived',
                'callback' => [FluentBoardsTrigger::class, 'boardArchived'],
            ],
            'boardRestored' => [
                'hook'     => 'fluent_boards/board_restored',
                'callback' => [FluentBoardsTrigger::class, 'boardRestored'],
            ],
            'boardDeleted' => [
                'hook'     => 'fluent_boards/before_board_deleted',
                'callback' => [FluentBoardsTrigger::class, 'boardDeleted'],
            ],
            'boardMemberAdded' => [
                'hook'          => 'fluent_boards/board_member_added',
                'callback'      => [FluentBoardsTrigger::class, 'boardMemberAdded'],
                'accepted_args' => 2,
            ],
            'boardViewerAdded' => [
                'hook'          => 'fluent_boards/board_viewer_added',
                'callback'      => [FluentBoardsTrigger::class, 'boardViewerAdded'],
                'accepted_args' => 2,
            ],
            'taskCreated' => [
                'hook'     => 'fluent_boards/task_created',
                'callback' => [FluentBoardsTrigger::class, 'taskCreated'],
            ],
            'taskUpdated' => [
                'hook'          => 'fluent_boards/task_updated',
                'callback'      => [FluentBoardsTrigger::class, 'taskUpdated'],
                'accepted_args' => 2,
            ],
            'taskStageUpdated' => [
                'hook'          => 'fluent_boards/task_stage_updated',
                'callback'      => [FluentBoardsTrigger::class, 'taskStageUpdated'],
                'accepted_args' => 2,
            ],
            'taskContentUpdated' => [
                'hook'          => 'fluent_boards/task_content_updated',
                'callback'      => [FluentBoardsTrigger::class, 'taskContentUpdated'],
                'accepted_args' => 3,
            ],
            'taskArchived' => [
                'hook'     => 'fluent_boards/task_archived',
                'callback' => [FluentBoardsTrigger::class, 'taskArchived'],
            ],
            'taskAssigneeAdded' => [
                'hook'          => 'fluent_boards/task_assignee_added',
                'callback'      => [FluentBoardsTrigger::class, 'taskAssigneeAdded'],
                'accepted_args' => 2,
            ],
            'taskAssigneeRemoved' => [
                'hook'          => 'fluent_boards/task_assignee_removed',
                'callback'      => [FluentBoardsTrigger::class, 'taskAssigneeRemoved'],
                'accepted_args' => 2,
            ],
            'taskPriorityUpdated' => [
                'hook'          => 'fluent_boards/task_priority_changed',
                'callback'      => [FluentBoardsTrigger::class, 'taskPriorityUpdated'],
                'accepted_args' => 2,
            ],
            'taskMovedBetweenBoards' => [
                'hook'          => 'fluent_boards/task_moved_from_board',
                'callback'      => [FluentBoardsTrigger::class, 'taskMovedBetweenBoards'],
                'accepted_args' => 3,
            ],
            'taskCloned' => [
                'hook'          => 'fluent_boards/task_cloned',
                'callback'      => [FluentBoardsTrigger::class, 'taskCloned'],
                'accepted_args' => 2,
            ],
            'taskDeleted' => [
                'hook'     => 'fluent_boards/before_task_deleted',
                'callback' => [FluentBoardsTrigger::class, 'taskDeleted'],
            ],
            'taskStartDateUpdated' => [
                'hook'          => 'fluent_boards/task_start_date_changed',
                'callback'      => [FluentBoardsTrigger::class, 'taskStartDateUpdated'],
                'accepted_args' => 2,
            ],
            'taskDueDateUpdated' => [
                'hook'          => 'fluent_boards/task_due_date_changed',
                'callback'      => [FluentBoardsTrigger::class, 'taskDueDateUpdated'],
                'accepted_args' => 2,
            ],
            'taskDueDateRemoved' => [
                'hook'     => 'fluent_boards/task_due_date_removed',
                'callback' => [FluentBoardsTrigger::class, 'taskDueDateRemoved'],
            ],
            'taskLabelAdded' => [
                'hook'          => 'fluent_boards/task_label',
                'callback'      => [FluentBoardsTrigger::class, 'taskLabelAdded'],
                'accepted_args' => 3,
            ],
            'taskLabelRemoved' => [
                'hook'          => 'fluent_boards/task_label',
                'callback'      => [FluentBoardsTrigger::class, 'taskLabelRemoved'],
                'accepted_args' => 3,
            ],
            'boardLabelCreated' => [
                'hook'     => 'fluent_boards/board_label_created',
                'callback' => [FluentBoardsTrigger::class, 'boardLabelCreated'],
            ],
            'boardLabelUpdated' => [
                'hook'     => 'fluent_boards/board_label_updated',
                'callback' => [FluentBoardsTrigger::class, 'boardLabelUpdated'],
            ],
            'boardLabelDeleted' => [
                'hook'     => 'fluent_boards/board_label_deleted',
                'callback' => [FluentBoardsTrigger::class, 'boardLabelDeleted'],
            ],
            'boardStageUpdated' => [
                'hook'          => 'fluent_boards/stage_updated',
                'callback'      => [FluentBoardsTrigger::class, 'boardStageUpdated'],
                'accepted_args' => 3,
            ],
            'boardStageArchived' => [
                'hook'          => 'fluent_boards/stage_archived',
                'callback'      => [FluentBoardsTrigger::class, 'boardStageArchived'],
                'accepted_args' => 2,
            ],
            'boardStageRestored' => [
                'hook'          => 'fluent_boards/board_stage_restored',
                'callback'      => [FluentBoardsTrigger::class, 'boardStageRestored'],
                'accepted_args' => 2,
            ],
            'subtaskAdded' => [
                'hook'          => 'fluent_boards/subtask_added',
                'callback'      => [FluentBoardsTrigger::class, 'subtaskAdded'],
                'accepted_args' => 2,
            ],
            'subtaskDeleted' => [
                'hook'          => 'fluent_boards/subtask_deleted_activity',
                'callback'      => [FluentBoardsTrigger::class, 'subtaskDeleted'],
                'accepted_args' => 2,
            ],
            'attachmentAdded' => [
                'hook'     => 'fluent_boards/task_attachment_added',
                'callback' => [FluentBoardsTrigger::class, 'attachmentAdded'],
            ],
            'attachmentDeleted' => [
                'hook'     => 'fluent_boards/task_attachment_deleted',
                'callback' => [FluentBoardsTrigger::class, 'attachmentDeleted'],
            ]
        ];
    }
}
