<?php

namespace BitApps\PiPro\src\Integrations\FluentCart;

use BitApps\Pi\src\Integrations\HookRegisterInterface;

if (!\defined('ABSPATH')) {
    exit;
}

class FluentCartHooks implements HookRegisterInterface
{
    public function register(): array
    {
        return [
            'productPurchased' => [
                'hook'     => 'fluent_cart/checkout/prepare_other_data',
                'callback' => [FluentCartTrigger::class, 'productPurchased'],
            ],
            'productUpdated' => [
                'hook'     => 'fluent_cart/product_updated',
                'callback' => [FluentCartTrigger::class, 'productUpdated'],
            ],
            'productStockUpdated' => [
                'hook'     => 'fluent_cart/product_stock_changed',
                'callback' => [FluentCartTrigger::class, 'productStockUpdated'],
            ],
            'couponCreated' => [
                'hook'     => 'fluent_cart/coupon_created',
                'callback' => [FluentCartTrigger::class, 'couponCreated'],
            ],
            'couponUpdated' => [
                'hook'     => 'fluent_cart/coupon_updated',
                'callback' => [FluentCartTrigger::class, 'couponUpdated'],
            ],
            'cartItemAdded' => [
                'hook'     => 'fluent_cart/cart/item_added',
                'callback' => [FluentCartTrigger::class, 'cartItemAdded'],
            ],
            'cartItemRemoved' => [
                'hook'     => 'fluent_cart/cart/item_removed',
                'callback' => [FluentCartTrigger::class, 'cartItemRemoved'],
            ],
            'cartItemsUpdated' => [
                'hook'     => 'fluent_cart/cart/cart_data_items_updated',
                'callback' => [FluentCartTrigger::class, 'cartItemsUpdated'],
            ],
            'cartUpdated' => [
                'hook'     => 'fluent_cart/checkout/cart_amount_updated',
                'callback' => [FluentCartTrigger::class, 'cartUpdated'],
            ],
            'cartCompleted' => [
                'hook'     => 'fluent_cart/cart_completed',
                'callback' => [FluentCartTrigger::class, 'cartCompleted'],
            ],
            'orderReceiptRendered' => [
                'hook'     => 'fluent_cart/after_receipt',
                'callback' => [FluentCartTrigger::class, 'orderReceiptRendered'],
            ],
            'orderCreated' => [
                'hook'     => 'fluent_cart/order_created',
                'callback' => [FluentCartTrigger::class, 'orderCreated'],
            ],
            'orderUpdated' => [
                'hook'     => 'fluent_cart/order_updated',
                'callback' => [FluentCartTrigger::class, 'orderUpdated'],
            ],
            'orderDeleted' => [
                'hook'     => 'fluent_cart/order_deleted',
                'callback' => [FluentCartTrigger::class, 'orderDeleted'],
            ],
            'orderRefunded' => [
                'hook'     => 'fluent_cart/order_refunded',
                'callback' => [FluentCartTrigger::class, 'orderRefunded'],
            ],
            'orderPartiallyRefunded' => [
                'hook'     => 'fluent_cart/order_partially_refunded',
                'callback' => [FluentCartTrigger::class, 'orderPartiallyRefunded'],
            ],
            'orderFullyRefunded' => [
                'hook'     => 'fluent_cart/order_fully_refunded',
                'callback' => [FluentCartTrigger::class, 'orderFullyRefunded'],
            ],
            'orderCancelled' => [
                'hook'     => 'fluent_cart/order_status_changed_to_canceled',
                'callback' => [FluentCartTrigger::class, 'orderCancelled'],
            ],
            'orderStatusChanged' => [
                'hook'     => 'fluent_cart/order_status_changed',
                'callback' => [FluentCartTrigger::class, 'orderStatusChanged'],
            ],
            'orderStatusUpdatedToProcessing' => [
                'hook'     => 'fluent_cart/order_status_changed_to_processing',
                'callback' => [FluentCartTrigger::class, 'orderStatusUpdatedToProcessing'],
            ],
            'orderStatusUpdatedToCompleted' => [
                'hook'     => 'fluent_cart/order_status_changed_to_completed',
                'callback' => [FluentCartTrigger::class, 'orderStatusUpdatedToCompleted'],
            ],
            'orderStatusUpdatedToOnHold' => [
                'hook'     => 'fluent_cart/order_status_changed_to_on-hold',
                'callback' => [FluentCartTrigger::class, 'orderStatusUpdatedToOnHold'],
            ],
            'orderShippingStatusChanged' => [
                'hook'     => 'fluent_cart/shipping_status_changed',
                'callback' => [FluentCartTrigger::class, 'orderShippingStatusChanged'],
            ],
            'orderShipped' => [
                'hook'     => 'fluent_cart/shipping_status_changed_to_shipped',
                'callback' => [FluentCartTrigger::class, 'orderShipped'],
            ],
            'orderUnshipped' => [
                'hook'     => 'fluent_cart/shipping_status_changed_to_unshipped',
                'callback' => [FluentCartTrigger::class, 'orderUnshipped'],
            ],
            'orderUnshippable' => [
                'hook'     => 'fluent_cart/shipping_status_changed_to_unshippable',
                'callback' => [FluentCartTrigger::class, 'orderUnshippable'],
            ],
            'orderDelivered' => [
                'hook'     => 'fluent_cart/shipping_status_changed_to_delivered',
                'callback' => [FluentCartTrigger::class, 'orderDelivered'],
            ],
            'orderMarkedAsPaid' => [
                'hook'     => 'fluent_cart/order_paid_done',
                'callback' => [FluentCartTrigger::class, 'orderMarkedAsPaid'],
            ],
            'orderCustomerChanged' => [
                'hook'     => 'fluent_cart/order_customer_changed',
                'callback' => [FluentCartTrigger::class, 'orderCustomerChanged'],
            ],
            'customerCreated' => [
                'hook'     => 'fluent_cart/user/after_register',
                'callback' => [FluentCartTrigger::class, 'customerCreated'],
            ]
        ];
    }
}
