<?php

namespace BitApps\PiPro\src\Integrations\FluentCommunity;

// Prevent direct script access
if (!\defined('ABSPATH')) {
    exit;
}

use BitApps\Pi\Services\FlowService;
use BitApps\PiPro\src\Integrations\IntegrationHelper;

final class FluentCommunityTrigger
{
    // Space Events
    public static function handleUserJoinsSpace($space, $userId, $by)
    {
        if (!($flows = FlowService::exists('fluentCommunity', 'userJoinsSpace'))) {
            return;
        }

        $data = FluentCommunityHelper::getUserJoinsSpaceData($space, $userId, $by);
        IntegrationHelper::handleFlowForForm($flows, $data);
    }

    public static function handleUserRequestsSpaceJoin($space, $userId)
    {
        if (!($flows = FlowService::exists('fluentCommunity', 'userRequestsSpaceJoin'))) {
            return;
        }

        $data = FluentCommunityHelper::getUserRequestsSpaceJoinData($space, $userId);
        IntegrationHelper::handleFlowForForm($flows, $data);
    }

    public static function handleUserLeavesSpace($space, $userId, $by)
    {
        if (!($flows = FlowService::exists('fluentCommunity', 'userLeavesSpace'))) {
            return;
        }

        $data = FluentCommunityHelper::getUserLeavesSpaceData($space, $userId, $by);
        IntegrationHelper::handleFlowForForm($flows, $data);
    }

    public static function handleNewSpaceCreated($space, $data)
    {
        if (!($flows = FlowService::exists('fluentCommunity', 'newSpaceCreated'))) {
            return;
        }

        $eventData = FluentCommunityHelper::getNewSpaceCreatedData($space, $data);
        IntegrationHelper::handleFlowForForm($flows, $eventData);
    }

    public static function handleAfterSpaceDeleted($spaceId)
    {
        if (!($flows = FlowService::exists('fluentCommunity', 'afterSpaceDeleted'))) {
            return;
        }

        $data = FluentCommunityHelper::getAfterSpaceDeletedData($spaceId);
        IntegrationHelper::handleFlowForForm($flows, $data);
    }

    public static function handleAfterSpaceUpdated($space, $args)
    {
        if (!($flows = FlowService::exists('fluentCommunity', 'afterSpaceUpdated'))) {
            return;
        }

        $data = FluentCommunityHelper::getAfterSpaceUpdatedData($space, $args);
        IntegrationHelper::handleFlowForForm($flows, $data);
    }

    // Feed Events
    public static function handleNewFeedCreated($feed)
    {
        if (!($flows = FlowService::exists('fluentCommunity', 'newFeedCreated'))) {
            return;
        }

        $data = FluentCommunityHelper::getNewFeedCreatedData($feed);
        IntegrationHelper::handleFlowForForm($flows, $data);
    }

    public static function handleNewSpaceFeedCreated($feed)
    {
        if (!($flows = FlowService::exists('fluentCommunity', 'newSpaceFeedCreated'))) {
            return;
        }

        $data = FluentCommunityHelper::getNewSpaceFeedCreatedData($feed);
        IntegrationHelper::handleFlowForForm($flows, $data);
    }

    public static function handleFeedUpdated($feed, $args)
    {
        if (!($flows = FlowService::exists('fluentCommunity', 'feedUpdated'))) {
            return;
        }

        $data = FluentCommunityHelper::getFeedUpdatedData($feed, $args);
        IntegrationHelper::handleFlowForForm($flows, $data);
    }

    public static function handleFeedMentionsUser($feed, $users)
    {
        if (!($flows = FlowService::exists('fluentCommunity', 'feedMentionsUser'))) {
            return;
        }

        $data = FluentCommunityHelper::getFeedMentionsUserData($feed, $users);
        IntegrationHelper::handleFlowForForm($flows, $data);
    }

    public static function handleBeforeFeedDeleted($feed)
    {
        if (!($flows = FlowService::exists('fluentCommunity', 'beforeFeedDeleted'))) {
            return;
        }

        $data = FluentCommunityHelper::getBeforeFeedDeletedData($feed);
        IntegrationHelper::handleFlowForForm($flows, $data);
    }

    public static function handleAfterFeedDeleted($feedId)
    {
        if (!($flows = FlowService::exists('fluentCommunity', 'afterFeedDeleted'))) {
            return;
        }

        $data = FluentCommunityHelper::getAfterFeedDeletedData($feedId);
        IntegrationHelper::handleFlowForForm($flows, $data);
    }

    public static function handleFeedReactionAdded($reaction, $feed)
    {
        if (!($flows = FlowService::exists('fluentCommunity', 'feedReactionAdded'))) {
            return;
        }

        $data = FluentCommunityHelper::getFeedReactionAddedData($reaction, $feed);
        IntegrationHelper::handleFlowForForm($flows, $data);
    }

    // Comment Events
    public static function handleNewCommentAdded($comment, $feed)
    {
        if (!($flows = FlowService::exists('fluentCommunity', 'newCommentAdded'))) {
            return;
        }

        $data = FluentCommunityHelper::getNewCommentAddedData($comment, $feed);
        IntegrationHelper::handleFlowForForm($flows, $data);
    }

    public static function handleCommentUpdated($comment, $feed)
    {
        if (!($flows = FlowService::exists('fluentCommunity', 'commentUpdated'))) {
            return;
        }

        $data = FluentCommunityHelper::getCommentUpdatedData($comment, $feed);
        IntegrationHelper::handleFlowForForm($flows, $data);
    }

    public static function handleCommentDeleted($commentId, $feed)
    {
        if (!($flows = FlowService::exists('fluentCommunity', 'commentDeleted'))) {
            return;
        }

        $data = FluentCommunityHelper::getCommentDeletedData($commentId, $feed);
        IntegrationHelper::handleFlowForForm($flows, $data);
    }

    // Course Events
    public static function handleUserEnrollsInCourse($course, $userId, $by)
    {
        if (!($flows = FlowService::exists('fluentCommunity', 'userEnrollsInCourse'))) {
            return;
        }

        $data = FluentCommunityHelper::getUserEnrollsInCourseData($course, $userId, $by);
        IntegrationHelper::handleFlowForForm($flows, $data);
    }

    public static function handleUserUnenrollsFromCourse($course, $userId, $by)
    {
        if (!($flows = FlowService::exists('fluentCommunity', 'userUnenrollsFromCourse'))) {
            return;
        }

        $data = FluentCommunityHelper::getUserUnenrollsFromCourseData($course, $userId, $by);
        IntegrationHelper::handleFlowForForm($flows, $data);
    }

    public static function handleUserCompletesCourse($course, $userId)
    {
        if (!($flows = FlowService::exists('fluentCommunity', 'userCompletesCourse'))) {
            return;
        }

        $data = FluentCommunityHelper::getUserCompletesCourseData($course, $userId);
        IntegrationHelper::handleFlowForForm($flows, $data);
    }

    public static function handleUserCompletesLesson($lesson, $userId)
    {
        if (!($flows = FlowService::exists('fluentCommunity', 'userCompletesLesson'))) {
            return;
        }

        $data = FluentCommunityHelper::getUserCompletesLessonData($lesson, $userId);
        IntegrationHelper::handleFlowForForm($flows, $data);
    }

    public static function handleCourseCreated($course)
    {
        if (!($flows = FlowService::exists('fluentCommunity', 'courseCreated'))) {
            return;
        }

        $data = FluentCommunityHelper::getCourseCreatedData($course);
        IntegrationHelper::handleFlowForForm($flows, $data);
    }

    public static function handleCourseUpdated($course, $args)
    {
        if (!($flows = FlowService::exists('fluentCommunity', 'courseUpdated'))) {
            return;
        }

        $data = FluentCommunityHelper::getCourseUpdatedData($course, $args);
        IntegrationHelper::handleFlowForForm($flows, $data);
    }

    public static function handleCoursePublished($course)
    {
        if (!($flows = FlowService::exists('fluentCommunity', 'coursePublished'))) {
            return;
        }

        $data = FluentCommunityHelper::getCoursePublishedData($course);
        IntegrationHelper::handleFlowForForm($flows, $data);
    }

    public static function handleCourseDeleted($courseId)
    {
        if (!($flows = FlowService::exists('fluentCommunity', 'courseDeleted'))) {
            return;
        }

        $data = FluentCommunityHelper::getCourseDeletedData($courseId);
        IntegrationHelper::handleFlowForForm($flows, $data);
    }

    public static function handleLessonUpdated($lesson, $updatedData, $isNewlyPublished)
    {
        if (!($flows = FlowService::exists('fluentCommunity', 'lessonUpdated'))) {
            return;
        }

        $data = FluentCommunityHelper::getLessonUpdatedData($lesson, $updatedData, $isNewlyPublished);
        IntegrationHelper::handleFlowForForm($flows, $data);
    }

    // User Events
    public static function handleUserLeveledUp($xprofile, $newLevel, $oldLevel)
    {
        if (!($flows = FlowService::exists('fluentCommunity', 'userLeveledUp'))) {
            return;
        }

        $data = FluentCommunityHelper::getUserLeveledUpData($xprofile, $newLevel, $oldLevel);
        IntegrationHelper::handleFlowForForm($flows, $data);
    }
}
