<?php

namespace BitApps\PiPro\src\Integrations\FluentCrm;

use BitApps\Pi\Helpers\Utility;
use BitApps\Pi\src\Flow\NodeInfoProvider;
use BitApps\Pi\src\Interfaces\ActionInterface;

if (!\defined('ABSPATH')) {
    exit;
}


class FluentCrmAction implements ActionInterface
{
    private $nodeInfoProvider;

    public function __construct(NodeInfoProvider $nodeInfoProvider)
    {
        $this->nodeInfoProvider = $nodeInfoProvider;
    }

    public function execute(): array
    {
        $executedNodeAction = $this->executeFluentCrmAction();

        return Utility::formatResponseData(
            $executedNodeAction['status_code'] ?? 200,
            $executedNodeAction['payload'] ?? [],
            $executedNodeAction['response'] ?? []
        );
    }

    private function executeFluentCrmAction()
    {
        $fluentCrmService = new FluentCrmServices($this->nodeInfoProvider);

        $machineSlug = $this->nodeInfoProvider->getMachineSlug();

        switch ($machineSlug) {
            case 'createContact':
                return $fluentCrmService->createContact();

            case 'getAllContact':
                return $fluentCrmService->getAllContact();

            case 'getContactById':
                return $fluentCrmService->getContactById();

            case 'getContactByEmail':
                return $fluentCrmService->getContactByEmail();

            case 'getContactByUserId':
                return $fluentCrmService->getContactByUserId();

            case 'getContactByTagIds':
                return $fluentCrmService->getContactByTagIds();

            case 'getContactByListIds':
                return $fluentCrmService->getContactByListIds();

            case 'getContactByStatus':
                return $fluentCrmService->getContactByStatus();

            case 'getCurrentContact':
                return $fluentCrmService->getCurrentContact();

            case 'getAllTag':
                return $fluentCrmService->getAllTag();

            case 'createTag':
                return $fluentCrmService->createTag();

            case 'addTagToContact':
                return $fluentCrmService->handleTagContactAction(true);

            case 'removeTagFromContact':
                return $fluentCrmService->handleTagContactAction(false);

            case 'getAllList':
                return $fluentCrmService->getAllList();

            case 'createList':
                return $fluentCrmService->createList();

            case 'addListToContact':
                return $fluentCrmService->handleListContactAction(true);

            case 'removeListFromContact':
                return $fluentCrmService->handleListContactAction(false);

            case 'getAllCompany':
                return $fluentCrmService->getAllCompany();

            case 'getCompanyById':
                return $fluentCrmService->getCompanyById();

            case 'createCompany':
                return $fluentCrmService->createCompany();

            case 'addCompanyToContact':
                return $fluentCrmService->handleCompanyContactAction(true);

            case 'removeCompanyFromContact':
                return $fluentCrmService->handleCompanyContactAction(false);

            case 'addEvent':
                return $fluentCrmService->addEvent();

            case 'addNote':
                return $fluentCrmService->addNote();

            case 'getAllCampaign':
                return $fluentCrmService->getAllCampaign();

            case 'getCampaignById':
                return $fluentCrmService->getCampaignById();

            case 'createCampaign':
                return $fluentCrmService->createCampaign();
        }
    }
}
