<?php

namespace BitApps\PiPro\src\Integrations\FormGent;

// Prevent direct script access
if (!\defined('ABSPATH')) {
    exit;
}


use BitApps\Pi\Services\FlowService;
use BitApps\PiPro\src\Integrations\IntegrationHelper;

final class FormGentTrigger
{
    public static function formSubmitted($responseId, $form, $request)
    {
        $data = [
            'response_id' => $responseId,
            'form'        => $form,
            'form_data'   => $request->get_param('form_data') ?? [],
        ];

        return self::execute('formSubmitted', $data);
    }

    public static function formCreated($form, $request)
    {
        $data = self::prepareFormData($form, $request);

        return self::execute('formCreated', $data);
    }

    public static function formTitleUpdated($request)
    {
        $data = $request->get_params() ?? [];

        return self::execute('formTitleUpdated', $data);
    }

    public static function formStatusUpdated($request)
    {
        $data = $request->get_params() ?? [];

        return self::execute('formStatusUpdated', $data);
    }

    public static function formDuplicated($form, $request)
    {
        $data = self::prepareFormData($form, $request);

        return self::execute('formDuplicated', $data);
    }

    public static function formDeleted($formId, $form)
    {
        return self::execute('formDeleted', $form);
    }

    public static function formResponsesDeleted($responseIds, $request)
    {
        $data = $request->get_params() ?? [];
        $data['response_ids'] = $responseIds;

        return self::execute('formResponsesDeleted', $data);
    }

    public static function formResponseStarred($request)
    {
        $data = $request->get_params() ?? [];

        return self::execute('formResponseStarred', $data);
    }

    public static function formResponseRead($request)
    {
        $data = $request->get_params() ?? [];

        return self::execute('formResponseRead', $data);
    }

    public static function viewQuizResult($request, $result)
    {
        $data = [
            'request_params' => $request->get_params() ?? [],
            'quiz_result'    => $result,
        ];

        return self::execute('viewQuizResult', $data);
    }

    private static function prepareFormData($form, $request)
    {
        return [
            'form_id'                 => $form->get_id() ?? null,
            'form_title'              => $form->get_title() ?? null,
            'form_status'             => $form->get_status() ?? null,
            'form_type'               => $form->get_type() ?? null,
            'form_content'            => (string) $form->get_content() ?? null,
            'form_fields'             => $form->get_fields() ?? null,
            'is_save_incomplete_data' => $form->is_save_incomplete_data() ?? null,
            'request_params'          => $request->get_params() ?? [],
        ];
    }

    private static function execute($machineSlug, $data)
    {
        $flows = FlowService::exists('formGent', $machineSlug);

        if (!$flows) {
            return;
        }

        IntegrationHelper::handleFlowForForm($flows, $data);
    }

    // TODO:: need to implement
    private static function isPluginInstalled()
    {
        return class_exists('FormGent');
    }
}
