<?php

namespace BitApps\PiPro\src\Integrations\Line;

// Prevent direct script access
if (!\defined('ABSPATH')) {
    exit;
}

use BitApps\Pi\Helpers\Utility;
use BitApps\Pi\src\Authorization\AuthorizationFactory;
use BitApps\Pi\src\Authorization\AuthorizationType;
use BitApps\Pi\src\Flow\NodeInfoProvider;
use BitApps\Pi\src\Interfaces\ActionInterface;
use BitApps\PiPro\src\Integrations\Line\helpers\LineActionHandler;

class LineAction implements ActionInterface
{
    private NodeInfoProvider $nodeInfoProvider;

    public function __construct(NodeInfoProvider $nodeInfoProvider)
    {
        $this->nodeInfoProvider = $nodeInfoProvider;
    }

    public function execute(): array
    {
        $executedNodeAction = $this->executeLineAction();

        return Utility::formatResponseData(
            $executedNodeAction['status_code'],
            $executedNodeAction['payload'],
            $executedNodeAction['response']
        );
    }

    private function executeMachine($machineSlug, $token, $data, $configs)
    {
        $header = [
            'Content-Type'  => 'application/json',
            'Authorization' => $token
        ];

        $lineService = new LineService($header);

        switch ($machineSlug) {
            case 'sendPushMessage':
                return $lineService->sendPushMessage($data);

            case 'sendReplyMessage':
                return $lineService->sendReplyMessage($data);

            case 'getNumberOfFollowers':
                return $lineService->getNumberOfFollowers($data['date']);

            case 'listOfMembers':
                return $lineService->listOfMembers($data);

            case 'getMemberProfile':
                return $lineService->getMemberProfile($data);

            case 'sendBroadcastMessage':
                $data = array_merge($data, ['notificationDisabled' => $configs['notification-id']['value']]);

                return $lineService->sendBroadcastMessage($data);
        }
    }

    private function executeLineAction()
    {
        $machineSlug = $this->nodeInfoProvider->getMachineSlug();
        $configs = $this->nodeInfoProvider->getFieldMapConfigs();
        $emojiRepeaterFields = $this->nodeInfoProvider->getFieldMapRepeaters('emoji-repeater-field.value', false, false);
        $audioRepeaterFields = $this->nodeInfoProvider->getFieldMapRepeaters('audio-repeater-field.value', false, false);
        $stickerRepeaterFields = $this->nodeInfoProvider->getFieldMapRepeaters('sticker-repeater-field.value', false, false);
        $imageRepeaterFields = $this->nodeInfoProvider->getFieldMapRepeaters('image-repeater-field.value', false, false);
        $locationRepeaterFields = $this->nodeInfoProvider->getFieldMapRepeaters('location-repeater-field.value', false, false);
        $videoRepeaterFields = $this->nodeInfoProvider->getFieldMapRepeaters('video-repeater-field.value', false, false);
        $fieldMapData = $this->nodeInfoProvider->getFieldMapData();

        $message = [
            'type' => 'text',
            'text' => $fieldMapData['text']
        ];

        $messageContent = LineActionHandler::prepareMessageContent(
            $configs,
            $message,
            $emojiRepeaterFields,
            $audioRepeaterFields,
            $videoRepeaterFields,
            $stickerRepeaterFields,
            $imageRepeaterFields,
            $locationRepeaterFields
        );

        $fieldMapData = array_merge($fieldMapData, ['messages' => $messageContent]);

        $tokenAuthorization = AuthorizationFactory::getAuthorizationHandler(
            AuthorizationType::BEARER_TOKEN,
            $configs['connection-id']
        );

        $token = $tokenAuthorization->getAccessToken();

        return $this->executeMachine($machineSlug, $token, $fieldMapData, $configs);
    }
}
