<?php

namespace BitApps\PiPro\src\Integrations\Line;

use BitApps\PiPro\Deps\BitApps\WPKit\Helpers\JSON;
use BitApps\PiPro\Deps\BitApps\WPKit\Http\Client\HttpClient;

if (!\defined('ABSPATH')) {
    exit;
}
class LineService
{
    private const BASE_URL = 'https://api.line.me/v2/bot';

    private $http;

    private $headers;

    /**
     * Line constructor.
     *
     * @param array  $headers
     */
    public function __construct($headers)
    {
        $this->http = new HttpClient();
        $this->headers = $headers;
    }

    /**
     * Send a Push Message to a Recipient.
     *
     * @param mixed $fieldMapData
     *
     * @return array
     */
    public function sendPushMessage($fieldMapData)
    {
        unset($fieldMapData['text']);
        $endPoint = self::BASE_URL . '/message/push';
        $pushMessageData = JSON::encode($fieldMapData);
        $response = $this->http->request($endPoint, 'POST', $pushMessageData, $this->headers);

        return [
            'response'    => $response,
            'payload'     => $pushMessageData,
            'status_code' => $this->http->getResponseCode()
        ];
    }

    /**
     * Send a Reply Message to a Recipient.
     *
     * @param mixed $fieldMapData
     *
     * @return array
     */
    public function sendReplyMessage($fieldMapData)
    {
        unset($fieldMapData['text']);
        $endPoint = self::BASE_URL . '/message/reply';
        $pushMessageData = JSON::encode($fieldMapData);
        $response = $this->http->request($endPoint, 'POST', $pushMessageData, $this->headers);

        return [
            'response'    => $response,
            'payload'     => $pushMessageData,
            'status_code' => $this->http->getResponseCode()
        ];
    }

    /**
     * Send a Broadcast Message.
     *
     * @param mixed $fieldMapData
     *
     * @return array
     */
    public function sendBroadcastMessage($fieldMapData)
    {
        unset($fieldMapData['text']);
        $endPoint = self::BASE_URL . '/message/broadcast';
        $broadcastMessage = JSON::encode($fieldMapData);
        $response = $this->http->request($endPoint, 'POST', $broadcastMessage, $this->headers);

        return [
            'response'    => $response,
            'payload'     => $broadcastMessage,
            'status_code' => $this->http->getResponseCode()
        ];
    }

    /**
     * Get a Number of Followers.
     *
     * @param mixed $date
     *
     * @return array
     */
    public function getNumberOfFollowers($date)
    {
        $endPoint = self::BASE_URL . '/insight/followers?date=' . $date;
        $response = $this->http->request($endPoint, 'GET', null, $this->headers);

        return [
            'response'    => $response,
            'payload'     => [],
            'status_code' => $this->http->getResponseCode()
        ];
    }

    /**
     * Get list of Group/Room Members.
     *
     * @param mixed $fieldMapData
     *
     * @return array
     */
    public function listOfMembers($fieldMapData)
    {
        if ($fieldMapData['groupOrRoom'] === 'group') {
            $endPoint = self::BASE_URL . '/group/' . $fieldMapData['groupId'] . '/members/ids';
        } elseif ($fieldMapData['groupOrRoom'] === 'room') {
            $endPoint = self::BASE_URL . '/room/' . $fieldMapData['roomId'] . '/members/ids';
        }

        $response = $this->http->request($endPoint, 'GET', null, $this->headers);

        return [
            'response'    => $response,
            'payload'     => [],
            'status_code' => $this->http->getResponseCode()
        ];
    }

    /**
     * Get list of Group/Room Member Profile.
     *
     * @param mixed $fieldMapData
     *
     * @return array
     */
    public function getMemberProfile($fieldMapData)
    {
        if ($fieldMapData['groupOrRoom'] === 'group') {
            $endPoint = self::BASE_URL . '/group/' . $fieldMapData['groupId'] . '/members/' . $fieldMapData['userId'];
        } elseif ($fieldMapData['groupOrRoom'] === 'room') {
            $endPoint = self::BASE_URL . '/room/' . $fieldMapData['roomId'] . '/members/' . $fieldMapData['userId'];
        }

        $response = $this->http->request($endPoint, 'GET', null, $this->headers);

        return [
            'response'    => $response,
            'payload'     => [],
            'status_code' => $this->http->getResponseCode()
        ];
    }
}
