<?php

namespace BitApps\PiPro\src\Integrations\MailMint;

use BitApps\Pi\Helpers\Utility;
use BitApps\Pi\src\Flow\NodeInfoProvider;
use BitApps\Pi\src\Interfaces\ActionInterface;

if (!\defined('ABSPATH')) {
    exit;
}


class MailMintAction implements ActionInterface
{
    private $nodeInfoProvider;

    public function __construct(NodeInfoProvider $nodeInfoProvider)
    {
        $this->nodeInfoProvider = $nodeInfoProvider;
    }

    public function execute(): array
    {
        if (!MailMintHelper::isPluginInstalled()) {
            // translators: %s: Plugin name
            return Utility::formatResponseData(500, [], \sprintf(__('%s is not installed or activated', 'bit-pi'), 'Mail Mint'));
        }

        $executedNodeAction = $this->executeMailMintAction();

        return Utility::formatResponseData(
            $executedNodeAction['status_code'] ?? 200,
            $executedNodeAction['payload'] ?? [],
            $executedNodeAction['response'] ?? []
        );
    }

    private function executeMailMintAction()
    {
        $mailMintService = new MailMintServices($this->nodeInfoProvider);

        $machineSlug = $this->nodeInfoProvider->getMachineSlug();

        switch ($machineSlug) {
            case 'getAllList':
                return $mailMintService->getAllList();

                break;

            case 'getListById':
                return $mailMintService->getListById();

                break;

            case 'createList':
                return $mailMintService->createList();

                break;

            case 'updateList':
                return $mailMintService->updateList();

                break;

            case 'deleteList':
                return $mailMintService->deleteList();

                break;

            case 'getAllTag':
                return $mailMintService->getAllTag();

                break;

            case 'getTagById':
                return $mailMintService->getTagById();

                break;

            case 'createTag':
                return $mailMintService->createTag();

                break;

            case 'updateTag':
                return $mailMintService->updateTag();

                break;

            case 'deleteTag':
                return $mailMintService->deleteTag();

                break;

            case 'getAllCampaign':
                return $mailMintService->getAllCampaign();

                break;

            case 'getCampaignById':
                return $mailMintService->getCampaignById();

                break;

            case 'getCampaignEmails':
                return $mailMintService->getCampaignEmails();

                break;

            case 'addRecipientsToCampaign':
                return $mailMintService->addRecipientsToCampaign();

                break;

            case 'deleteCampaign':
                return $mailMintService->deleteCampaign();

                break;

            case 'getAllContact':
                return $mailMintService->getAllContact();

                break;

            case 'getContactById':
                return $mailMintService->getContactById();

                break;

            case 'addListsToContact':
                return $mailMintService->addListsToContact();

                break;

            case 'removeListsFromContact':
                return $mailMintService->removeListsFromContact();

                break;

            case 'addTagsToContact':
                return $mailMintService->addTagsToContact();

                break;

            case 'removeTagsFromContact':
                return $mailMintService->removeTagsFromContact();

                break;

            case 'createContact':
                return $mailMintService->createContact();

                break;

            case 'deleteContact':
                return $mailMintService->deleteContact();

                break;

            case 'getContactNotes':
                return $mailMintService->getContactNotes();

                break;

            case 'addContactNote':
                return $mailMintService->addContactNote();

                break;

            case 'deleteContactNote':
                return $mailMintService->deleteContactNote();

                break;
        }
    }
}
