<?php

namespace BitApps\PiPro\src\Integrations\MailMint;

use BitApps\Pi\src\Integrations\HookRegisterInterface;

if (!\defined('ABSPATH')) {
    exit;
}

class MailMintHooks implements HookRegisterInterface
{
    public function register(): array
    {
        return [
            'formSubmitted' => [
                'hook'          => 'mailmint_after_form_submit',
                'callback'      => [MailMintTrigger::class, 'formSubmitted'],
                'accepted_args' => 2,
            ],
            'contactCreated' => [
                'hook'     => 'mint_after_contact_creation',
                'callback' => [MailMintTrigger::class, 'contactCreated'],
            ],
            'contactDeleted' => [
                'hook'     => 'mailmint_after_delete_contact',
                'callback' => [MailMintTrigger::class, 'contactDeleted'],
            ],
            'tagsAddedToContact' => [
                'hook'          => 'mailmint_tag_applied',
                'callback'      => [MailMintTrigger::class, 'tagsAddedToContact'],
                'accepted_args' => 2,
            ],
            'listsAddedToContact' => [
                'hook'          => 'mailmint_list_applied',
                'callback'      => [MailMintTrigger::class, 'listsAddedToContact'],
                'accepted_args' => 2,
            ],
            'campaignCreated' => [
                'hook'          => 'mailmint_campaign_created',
                'callback'      => [MailMintTrigger::class, 'campaignCreated'],
                'accepted_args' => 2,
            ],
            'campaignEmailSent' => [
                'hook'     => 'mailmint_after_campaign_start',
                'callback' => [MailMintTrigger::class, 'campaignEmailSent'],
            ],
        ];
    }
}
