<?php

namespace BitApps\PiPro\src\Integrations\MailerPress;

use BitApps\Pi\src\Integrations\HookRegisterInterface;

if (!\defined('ABSPATH')) {
    exit;
}

class MailerPressHooks implements HookRegisterInterface
{
    public function register(): array
    {
        return [
            'contactCreated' => [
                'hook'     => 'mailerpress_contact_created',
                'callback' => [MailerPressTrigger::class, 'contactCreated'],
            ],
            'contactUpdated' => [
                'hook'     => 'mailerpress_contact_updated',
                'callback' => [MailerPressTrigger::class, 'contactUpdated'],
            ],
            'contactTagAdded' => [
                'hook'          => 'mailerpress_contact_tag_added',
                'callback'      => [MailerPressTrigger::class, 'contactTagAdded'],
                'accepted_args' => 2,
            ],
            'contactTagRemoved' => [
                'hook'          => 'mailerpress_contact_tag_removed',
                'callback'      => [MailerPressTrigger::class, 'contactTagRemoved'],
                'accepted_args' => 2,
            ],
            'contactListAdded' => [
                'hook'          => 'mailerpress_contact_list_added',
                'callback'      => [MailerPressTrigger::class, 'contactListAdded'],
                'accepted_args' => 2,
            ],
            'contactListRemoved' => [
                'hook'          => 'mailerpress_contact_list_removed',
                'callback'      => [MailerPressTrigger::class, 'contactListRemoved'],
                'accepted_args' => 2,
            ],
            'contactUnsubscribed' => [
                'hook'     => 'mailerpress_unsubscribe',
                'callback' => [MailerPressTrigger::class, 'contactUnsubscribed'],
            ],
            'campaignCreated' => [
                'hook'     => 'mailerpress_campaign_created',
                'callback' => [MailerPressTrigger::class, 'campaignCreated'],
            ],
            'listCreated' => [
                'hook'     => 'mailerpress_list_created',
                'callback' => [MailerPressTrigger::class, 'listCreated'],
            ],
            'tagCreated' => [
                'hook'     => 'mailerpress_tag_created',
                'callback' => [MailerPressTrigger::class, 'tagCreated'],
            ],
        ];
    }
}
