<?php

namespace BitApps\PiPro\src\Integrations\MailerPress;

// Prevent direct script access
if (!\defined('ABSPATH')) {
    exit;
}

use BitApps\Pi\Services\FlowService;
use BitApps\PiPro\src\Integrations\IntegrationHelper;

final class MailerPressTrigger
{
    public static function contactCreated($contactId)
    {
        $contact = MailerPressHelper::getContactDataById($contactId);

        if (!$contact) {
            return;
        }

        self::execute(__FUNCTION__, $contact);
    }

    public static function contactUpdated($contactId)
    {
        $contact = MailerPressHelper::getContactDataById($contactId);

        if (!$contact) {
            return;
        }

        self::execute(__FUNCTION__, $contact);
    }

    public static function contactTagAdded($contactId, $tagId)
    {
        $contact = MailerPressHelper::getContactDataById($contactId);

        if (!$contact) {
            return;
        }

        $contact['added_tag_id'] = $tagId;

        self::execute(__FUNCTION__, $contact);
    }

    public static function contactTagRemoved($contactId, $tagId)
    {
        $contact = MailerPressHelper::getContactDataById($contactId);

        if (!$contact) {
            return;
        }

        $contact['removed_tag_id'] = $tagId;

        self::execute(__FUNCTION__, $contact);
    }

    public static function contactListAdded($contactId, $listId)
    {
        $contact = MailerPressHelper::getContactDataById($contactId);

        if (!$contact) {
            return;
        }

        $contact['added_list_id'] = $listId;

        self::execute(__FUNCTION__, $contact);
    }

    public static function contactListRemoved($contactId, $listId)
    {
        $contact = MailerPressHelper::getContactDataById($contactId);

        if (!$contact) {
            return;
        }

        $contact['removed_list_id'] = $listId;

        self::execute(__FUNCTION__, $contact);
    }

    public static function contactUnsubscribed()
    {
        $contactData = [];

        if (isset($_GET['data'])) {
            global $wpdb;

            $tableName = $wpdb->prefix . 'mailerpress_contact';
            $token = sanitize_text_field(wp_unslash($_GET['data']));

            $contact = $wpdb->get_row(
                $wpdb->prepare(
                    "SELECT * FROM {$tableName} WHERE unsubscribe_token = %s",
                    $token
                )
            );

            if ($contact) {
                $contactData = (array) $contact;
            }
        }

        $contactData['action'] = 'unsubscribed';
        $contactData['timestamp'] = current_time('mysql');

        self::execute(__FUNCTION__, $contactData);
    }

    public static function campaignCreated($campaign)
    {
        if (!\is_array($campaign)) {
            $campaign = (array) $campaign;
        }

        self::execute(__FUNCTION__, $campaign);
    }

    public static function listCreated($listId)
    {
        global $wpdb;
        $tableName = $wpdb->prefix . 'mailerpress_lists';

        $listData = $wpdb->get_row(
            $wpdb->prepare(
                "SELECT * FROM {$tableName} WHERE list_id = %d",
                $listId
            ),
            ARRAY_A
        );

        if (!$listData) {
            return;
        }

        if (!\is_array($listData)) {
            $listData = (array) $listData;
        }

        self::execute(__FUNCTION__, $listData);
    }

    public static function tagCreated($tag)
    {
        $tagId = isset($tag->tag_id) ? $tag->tag_id : $tag;

        if (is_numeric($tagId)) {
            global $wpdb;
            $tableName = $wpdb->prefix . 'mailerpress_tags';

            $tagData = $wpdb->get_row(
                $wpdb->prepare(
                    "SELECT * FROM {$tableName} WHERE tag_id = %d",
                    $tagId
                ),
                ARRAY_A
            );
        }

        if (!$tagData) {
            return;
        }

        if (!\is_array($tagData)) {
            $tagData = (array) $tagData;
        }

        return self::execute(__FUNCTION__, $tagData);
    }

    private static function execute($machineSlug, $data)
    {
        $flows = FlowService::exists('mailerPress', $machineSlug);

        if (!$flows) {
            return;
        }

        IntegrationHelper::handleFlowForForm($flows, $data);
    }
}
