<?php

namespace BitApps\PiPro\src\Integrations\MetForm;

// Prevent direct script access
if (!\defined('ABSPATH')) {
    exit;
}


use BitApps\Pi\Services\FlowService;
use BitApps\PiPro\src\Integrations\IntegrationHelper;

class MetFormTrigger
{
    public static function handleSubmit($formId, $formData, $formSettings, $attributes)
    {
        if (empty($formId)) {
            return;
        }

        $flows = FlowService::exists('metForm', 'formSubmit');

        if (!$flows) {
            return;
        }

        $formData['form_id'] = (int) $formId;

        if (!empty($attributes['file_upload_info'])) {
            foreach ($attributes['file_upload_info'] as $key => $file) {
                $formData[$key] = array_column($file, 'url');
            }
        }

        IntegrationHelper::handleFlowForForm($flows, $formData, $formData['form_id']);
    }
}
