<?php

namespace BitApps\PiPro\src\Integrations\Newsletter;

use BitApps\Pi\Helpers\Utility;
use BitApps\Pi\src\Flow\NodeInfoProvider;
use BitApps\Pi\src\Interfaces\ActionInterface;

if (!\defined('ABSPATH')) {
    exit;
}


class NewsletterAction implements ActionInterface
{
    private $nodeInfoProvider;

    public function __construct(NodeInfoProvider $nodeInfoProvider)
    {
        $this->nodeInfoProvider = $nodeInfoProvider;
    }

    public function execute(): array
    {
        $executedNodeAction = $this->executeNewsletterAction();

        return Utility::formatResponseData(
            $executedNodeAction['status_code'] ?? 200,
            $executedNodeAction['payload'] ?? [],
            $executedNodeAction['response'] ?? []
        );
    }

    private function executeNewsletterAction()
    {
        $newsletter = new NewsletterServices($this->nodeInfoProvider);

        $machineSlug = $this->nodeInfoProvider->getMachineSlug();

        switch ($machineSlug) {
            case 'createSubscriptions':
                return $newsletter->createSubscriptions();

            case 'getAllSubscriber':
                return $newsletter->getAllSubscriber();

            case 'getSubscriberByEmail':
                return $newsletter->getSubscriberByEmail();

            case 'getSubscriberById':
                return $newsletter->getSubscriberById();

            case 'createSubscriber':
                return $newsletter->createSubscriber();

            case 'updateSubscriber':
                return $newsletter->updateSubscriber();

            case 'deleteSubscriberById':
                return $newsletter->deleteSubscriberById();

            case 'deleteSubscriberByEmail':
                return $newsletter->deleteSubscriberByEmail();

            case 'getAllNewsletter':
                return $newsletter->getAllNewsletter();

            case 'getNewsletterById':
                return $newsletter->getNewsletterById();

            case 'getAllList':
                return $newsletter->getAllList();

            case 'getListById':
                return $newsletter->getListById();

            default:
                return [
                    'response'    => __('Invalid machine slug.', 'bit-pi'),
                    'payload'     => [],
                    'status_code' => 400,
                ];
        }
    }
}
