<?php

namespace BitApps\PiPro\src\Integrations\Newsletter;

// Prevent direct script access
if (!\defined('ABSPATH')) {
    exit;
}

use BitApps\Pi\Services\FlowService;
use BitApps\PiPro\src\Integrations\IntegrationHelper;

final class NewsletterTrigger
{
    /**
     * Handle subscription form submitted event.
     *
     * @param object $userData
     */
    public static function subscriptionFormSubmitted($userData)
    {
        return self::execute('subscriptionFormSubmitted', $userData);
    }

    /**
     * Handle user confirmed event.
     *
     * @param object $userData
     */
    public static function userConfirmed($userData)
    {
        return self::execute('userConfirmed', $userData);
    }

    /**
     * Handle user unsubscribed event.
     *
     * @param object $userData
     */
    public static function userUnsubscribed($userData)
    {
        return self::execute('userUnsubscribed', $userData);
    }

    /**
     * Handle user reactivated event.
     *
     * @param object $userData
     */
    public static function userReactivated($userData)
    {
        return self::execute('userReactivated', $userData);
    }

    /**
     * Handle newsletter send end event.
     *
     * @param object $emailData
     */
    public static function newsletterSendEnd($emailData)
    {
        return self::execute('newsletterSendEnd', $emailData);
    }

    /**
     * Execute the trigger.
     *
     * @param string $machineSlug
     * @param array  $data
     */
    private static function execute($machineSlug, $data)
    {
        $flows = FlowService::exists('Newsletter', $machineSlug);
        if (!$flows) {
            return;
        }

        IntegrationHelper::handleFlowForForm($flows, $data);
    }
}
