<?php

namespace BitApps\PiPro\src\Integrations\Poptics;

use BitApps\Pi\src\Integrations\HookRegisterInterface;

if (!\defined('ABSPATH')) {
    exit;
}

class PopticsHooks implements HookRegisterInterface
{
    public function register(): array
    {
        return [
            'submissionCreated' => [
                'hook'     => 'poptics_after_submission_create',
                'callback' => [PopticsTrigger::class, 'submissionCreated'],
            ],
            'campaignDeleted' => [
                'hook'     => 'poptics_campaign_deleted',
                'callback' => [PopticsTrigger::class, 'campaignDeleted'],
            ],
        ];
    }
}
