<?php

namespace BitApps\PiPro\src\Integrations\Poptics;

use BitApps\Pi\Services\FlowService;
use BitApps\PiPro\src\Integrations\IntegrationHelper;
use Poptics\Core\Campaign\Campaign;

if (!\defined('ABSPATH')) {
    exit;
}

final class PopticsTrigger
{
    public static function submissionCreated($data)
    {
        if (empty($data)) {
            return;
        }

        if (isset($data['campaign_id']) && class_exists('Poptics\Core\Campaign\Campaign')) {
            $campaign = new Campaign($data['campaign_id']);
            $data['campaign'] = $campaign->get_data();
        }

        return self::execute(__FUNCTION__, $data);
    }

    public static function campaignDeleted($campaignId)
    {
        if (empty($campaignId)) {
            return;
        }

        return self::execute(__FUNCTION__, ['campaign_id' => $campaignId]);
    }

    private static function execute($machineSlug, $data)
    {
        $flows = FlowService::exists('poptics', $machineSlug);

        if (!$flows) {
            return;
        }

        IntegrationHelper::handleFlowForForm($flows, $data);
    }
}
