<?php

namespace BitApps\PiPro\src\Integrations\SureMembers;

use BitApps\Pi\Helpers\Utility;
use BitApps\Pi\src\Flow\NodeInfoProvider;
use BitApps\Pi\src\Interfaces\ActionInterface;

if (!\defined('ABSPATH')) {
    exit;
}


class SureMembersAction implements ActionInterface
{
    private $nodeInfoProvider;

    public function __construct(NodeInfoProvider $nodeInfoProvider)
    {
        $this->nodeInfoProvider = $nodeInfoProvider;
    }

    public function execute(): array
    {
        if (!is_plugin_active('suremembers/suremembers.php')) {
            // translators: %s: Plugin name.
            return Utility::formatResponseData(500, [], \sprintf(__('%s is not installed or activated', 'bit-pi'), 'SureMembers'));
        }

        $executedNodeAction = $this->executeSureMembersAction();

        return Utility::formatResponseData(
            $executedNodeAction['status_code'] ?? 200,
            $executedNodeAction['payload'] ?? [],
            $executedNodeAction['response'] ?? []
        );
    }

    private function executeSureMembersAction()
    {
        $service = new SureMembersServices($this->nodeInfoProvider);

        $machineSlug = $this->nodeInfoProvider->getMachineSlug();

        switch ($machineSlug) {
            case 'addUserToAccessGroup':
                return $service->addUserToAccessGroup();

                break;

            case 'removeUserFromAccessGroup':
                return $service->removeUserFromAccessGroup();

                break;
        }
    }
}
