<?php

namespace BitApps\PiPro\src\Integrations\Twilio;

use BitApps\Pi\Helpers\Utility;
use BitApps\Pi\src\Authorization\AuthorizationFactory;
use BitApps\Pi\src\Authorization\AuthorizationType;
use BitApps\Pi\src\Flow\NodeInfoProvider;
use BitApps\Pi\src\Interfaces\ActionInterface;
use BitApps\PiPro\Deps\BitApps\WPKit\Http\Client\HttpClient;

if (!\defined('ABSPATH')) {
    exit;
}
class TwilioAction implements ActionInterface
{
    private NodeInfoProvider $nodeInfoProvider;

    private TwilioService $twilioService;

    public function __construct(NodeInfoProvider $nodeInfoProvider)
    {
        $this->nodeInfoProvider = $nodeInfoProvider;
    }

    public function execute(): array
    {
        $executedNodeAction = $this->executeTwilioAction();

        return Utility::formatResponseData(
            $executedNodeAction['status_code'],
            $executedNodeAction['payload'],
            $executedNodeAction['response']
        );
    }

    private function executeMachine($machineSlug, $data, $configs)
    {
        switch ($machineSlug) {
            case 'sendSms':
                return $this->twilioService->sendSms($data);

            case 'getMessage':
                return $this->twilioService->getMessage($data['messageId'] ?? '');

            case 'getCall':
                return $this->twilioService->getCall($data['callId'] ?? '');

            case 'getAllMessages':
                $filterSwitch = $configs['filter-with-numbers-switch']['value'];

                return $this->twilioService->getAllMessages($filterSwitch, $data);

            case 'getAllCalls':
                $filterSwitch = $configs['filter-with-numbers-switch']['value'];

                return $this->twilioService->getAllCalls($filterSwitch, $data);

            case 'cellPhone':
                return $this->twilioService->cellPhone($data);
        }
    }

    private function executeTwilioAction()
    {
        $machineSlug = $this->nodeInfoProvider->getMachineSlug();
        $connectionId = $this->nodeInfoProvider->getFieldMapConfigs('connection-id.value');
        $data = $this->nodeInfoProvider->getFieldMapData();
        $configs = $this->nodeInfoProvider->getFieldMapConfigs();

        $basicAuthAuthorization = AuthorizationFactory::getAuthorizationHandler(
            AuthorizationType::BASIC_AUTH,
            $connectionId
        );

        $connection = $basicAuthAuthorization->getConnection();
        $authDetails = $connection->auth_details;
        $accountSid = $authDetails->username;
        $authToken = $authDetails->password;

        $httpClient = new HttpClient(
            [
                'headers' => [
                    'Content-Type'  => 'application/x-www-form-urlencoded',
                    'Authorization' => 'Basic ' . base64_encode($accountSid . ':' . $authToken)
                ],
            ]
        );

        $this->twilioService = new TwilioService($httpClient, $accountSid);

        return $this->executeMachine($machineSlug, $data, $configs);
    }
}
