<?php

namespace BitApps\PiPro\src\Integrations\WPUserFrontend;

use BitApps\Pi\src\Integrations\HookRegisterInterface;

if (!\defined('ABSPATH')) {
    exit;
}

class WPUserFrontendHooks implements HookRegisterInterface
{
    public function register(): array
    {
        return [
            'postFormSubmission' => [
                'hook'          => 'wpuf_add_post_after_insert',
                'callback'      => [WPUserFrontendTrigger::class, 'postFormSubmission'],
                'priority'      => 10,
                'accepted_args' => 4,
            ],
            'registrationFormSubmission' => [
                'hook'          => 'wpuf_after_register',
                'callback'      => [WPUserFrontendTrigger::class, 'registrationFormSubmission'],
                'priority'      => 10,
                'accepted_args' => 3,
            ],
            'subscriptionPackUpdated' => [
                'hook'          => 'wpuf_before_update_subscription_pack',
                'callback'      => [WPUserFrontendTrigger::class, 'subscriptionPackUpdated'],
                'priority'      => 10,
                'accepted_args' => 3,
            ],
            'couponCreated' => [
                'hook'          => 'wp_after_insert_post',
                'callback'      => [WPUserFrontendTrigger::class, 'couponCreated'],
                'priority'      => 10,
                'accepted_args' => 4,
            ],
            'couponUpdated' => [
                'hook'          => 'wpuf_update_coupon',
                'callback'      => [WPUserFrontendTrigger::class, 'couponUpdated'],
                'priority'      => 10,
                'accepted_args' => 2,
            ],
            'profileUpdated' => [
                'hook'          => 'wpuf_update_profile',
                'callback'      => [WPUserFrontendTrigger::class, 'profileUpdated'],
                'priority'      => 10,
                'accepted_args' => 4,
            ],
            'userMetadataUpdated' => [
                'hook'          => 'wpuf_pro_frontend_form_update_user_meta',
                'callback'      => [WPUserFrontendTrigger::class, 'userMetadataUpdated'],
                'priority'      => 10,
                'accepted_args' => 2,
            ]
        ];
    }
}
