<?php

namespace BitApps\PiPro\src\Integrations\WishlistMember;

use BitApps\Pi\Helpers\Utility;
use BitApps\Pi\src\Flow\NodeInfoProvider;
use BitApps\Pi\src\Interfaces\ActionInterface;

if (!\defined('ABSPATH')) {
    exit;
}


class WishlistMemberAction implements ActionInterface
{
    private $nodeInfoProvider;

    public function __construct(NodeInfoProvider $nodeInfoProvider)
    {
        $this->nodeInfoProvider = $nodeInfoProvider;
    }

    public function execute(): array
    {
        if (!WishlistMemberHelper::isPluginInstalled()) {
            // translators: %s: Plugin name
            return Utility::formatResponseData(500, [], \sprintf(__('%s is not installed or activated', 'bit-pi'), 'WishlistMember'));
        }

        $executedNodeAction = $this->executeWishlistMemberAction();

        return Utility::formatResponseData(
            $executedNodeAction['status_code'] ?? 200,
            $executedNodeAction['payload'] ?? [],
            $executedNodeAction['response'] ?? []
        );
    }

    private function executeWishlistMemberAction()
    {
        $wishlistMember = new WishlistMemberServices($this->nodeInfoProvider);

        $machineSlug = $this->nodeInfoProvider->getMachineSlug();

        switch ($machineSlug) {
            case 'createLevel':
                return $wishlistMember->createLevel();

                break;

            case 'updateLevel':
                return $wishlistMember->updateLevel();

                break;

            case 'getAllLevel':
                return $wishlistMember->getAllLevel();

                break;

            case 'getLevelById':
                return $wishlistMember->getLevelById();

                break;

            case 'deleteLevel':
                return $wishlistMember->deleteLevel();

                break;

            case 'createMember':
                return $wishlistMember->createMember();

                break;

            case 'updateMember':
                return $wishlistMember->updateMember();

                break;

            case 'getAllMember':
                return $wishlistMember->getAllMember();

                break;

            case 'getMemberById':
                return $wishlistMember->getMemberById();

                break;

            case 'getMemberByEmail':
                return $wishlistMember->getMemberByEmail();

                break;

            case 'getMemberByUsername':
                return $wishlistMember->getMemberByUsername();

                break;

            case 'getMemberLevels':
                return $wishlistMember->getMemberLevels();

                break;

            case 'deleteMember':
                return $wishlistMember->deleteMember();

                break;

            case 'checkUserIsMemberOfLevel':
                return $wishlistMember->checkUserIsMemberOfLevel();

                break;

            case 'addMemberToLevel':
                return $wishlistMember->addMemberToLevel();

                break;

            case 'removeMemberFromLevel':
                return $wishlistMember->removeMemberFromLevel();

                break;
        }
    }
}
