<?php

namespace BitApps\PiPro\src\Integrations\WishlistMember;

use BitApps\Pi\src\Integrations\HookRegisterInterface;

if (!\defined('ABSPATH')) {
    exit;
}

class WishlistMemberHooks implements HookRegisterInterface
{
    public function register(): array
    {
        return [
            'memberAddedToLevel' => [
                'hook'          => 'wishlistmember_add_user_levels',
                'callback'      => [WishlistMemberTrigger::class, 'memberAddedToLevel'],
                'priority'      => 10,
                'accepted_args' => 2,
            ],
            'memberRemovedFromLevel' => [
                'hook'          => 'wishlistmember_remove_user_levels',
                'callback'      => [WishlistMemberTrigger::class, 'memberRemovedFromLevel'],
                'priority'      => 10,
                'accepted_args' => 2,
            ],
            'memberApprovedOnLevel' => [
                'hook'          => 'wishlistmember_approve_user_levels',
                'callback'      => [WishlistMemberTrigger::class, 'memberApprovedOnLevel'],
                'priority'      => 10,
                'accepted_args' => 2,
            ],
            'memberUnapprovedOnLevel' => [
                'hook'          => 'wishlistmember_unapprove_user_levels',
                'callback'      => [WishlistMemberTrigger::class, 'memberUnapprovedOnLevel'],
                'priority'      => 10,
                'accepted_args' => 2,
            ],
            'memberConfirmedOnLevel' => [
                'hook'          => 'wishlistmember_confirm_user_levels',
                'callback'      => [WishlistMemberTrigger::class, 'memberConfirmedOnLevel'],
                'priority'      => 10,
                'accepted_args' => 2,
            ],
            'memberUnconfirmedOnLevel' => [
                'hook'          => 'wishlistmember_unconfirm_user_levels',
                'callback'      => [WishlistMemberTrigger::class, 'memberUnconfirmedOnLevel'],
                'priority'      => 10,
                'accepted_args' => 2,
            ],
            'memberCancelledFromLevel' => [
                'hook'          => 'wishlistmember_cancel_user_levels',
                'callback'      => [WishlistMemberTrigger::class, 'memberCancelledFromLevel'],
                'priority'      => 10,
                'accepted_args' => 2,
            ],
            'memberUncancelledFromLevel' => [
                'hook'          => 'wishlistmember_uncancel_user_levels',
                'callback'      => [WishlistMemberTrigger::class, 'memberUncancelledFromLevel'],
                'priority'      => 10,
                'accepted_args' => 2,
            ],
        ];
    }
}
