<?php

namespace BitApps\PiPro\src\Integrations\WishlistMember;

// Prevent direct script access
if (!\defined('ABSPATH')) {
    exit;
}

use BitApps\Pi\Services\FlowService;
use BitApps\PiPro\src\Integrations\IntegrationHelper;

final class WishlistMemberTrigger
{
    /**
     * Handle member added to level event.
     *
     * @param int $userId
     * @param array|int $levelId
     */
    public static function memberAddedToLevel($userId, $levelId)
    {
        $data = WishlistMemberHelper::prepareMembershipData($userId, $levelId);

        if (empty($data)) {
            return;
        }

        return self::execute('memberAddedToLevel', $data);
    }

    /**
     * Handle member removed from level event.
     *
     * @param int $userId
     * @param array|int $levelId
     */
    public static function memberRemovedFromLevel($userId, $levelId)
    {
        $data = WishlistMemberHelper::prepareMembershipData($userId, $levelId);

        if (empty($data)) {
            return;
        }

        return self::execute('memberRemovedFromLevel', $data);
    }

    /**
     * Handle member approved on level event.
     *
     * @param int $userId
     * @param array|int $levelId
     */
    public static function memberApprovedOnLevel($userId, $levelId)
    {
        $data = WishlistMemberHelper::prepareMembershipData($userId, $levelId);

        if (empty($data)) {
            return;
        }

        return self::execute('memberApprovedOnLevel', $data);
    }

    /**
     * Handle member unapproved on level event.
     *
     * @param int $userId
     * @param array|int $levelId
     */
    public static function memberUnapprovedOnLevel($userId, $levelId)
    {
        $data = WishlistMemberHelper::prepareMembershipData($userId, $levelId);

        if (empty($data)) {
            return;
        }

        return self::execute('memberUnapprovedOnLevel', $data);
    }

    /**
     * Handle member confirmed on level event.
     *
     * @param int $userId
     * @param array|int $levelId
     */
    public static function memberConfirmedOnLevel($userId, $levelId)
    {
        $data = WishlistMemberHelper::prepareMembershipData($userId, $levelId);

        if (empty($data)) {
            return;
        }

        return self::execute('memberConfirmedOnLevel', $data);
    }

    /**
     * Handle member unconfirmed on level event.
     *
     * @param int $userId
     * @param array|int $levelId
     */
    public static function memberUnconfirmedOnLevel($userId, $levelId)
    {
        $data = WishlistMemberHelper::prepareMembershipData($userId, $levelId);

        if (empty($data)) {
            return;
        }

        return self::execute('memberUnconfirmedOnLevel', $data);
    }

    /**
     * Handle member cancelled from level event.
     *
     * @param int $userId
     * @param array|int $levelId
     */
    public static function memberCancelledFromLevel($userId, $levelId)
    {
        $data = WishlistMemberHelper::prepareMembershipData($userId, $levelId);

        if (empty($data)) {
            return;
        }

        return self::execute('memberCancelledFromLevel', $data);
    }

    /**
     * Handle member uncancelled from level event.
     *
     * @param int $userId
     * @param array|int $levelId
     */
    public static function memberUncancelledFromLevel($userId, $levelId)
    {
        $data = WishlistMemberHelper::prepareMembershipData($userId, $levelId);

        if (empty($data)) {
            return;
        }

        return self::execute('memberUncancelledFromLevel', $data);
    }

    /**
     * Execute the trigger.
     *
     * @param string $machineSlug
     * @param array  $data
     */
    private static function execute($machineSlug, $data)
    {
        $flows = FlowService::exists('WishlistMember', $machineSlug);
        if (!$flows) {
            return;
        }

        IntegrationHelper::handleFlowForForm($flows, $data);
    }
}
