<?php

namespace BitApps\PiPro\src\Integrations\ZohoProject;

use BitApps\Pi\Helpers\Utility;
use BitApps\Pi\src\Authorization\AuthorizationFactory;
use BitApps\Pi\src\Authorization\AuthorizationType;
use BitApps\Pi\src\Flow\NodeInfoProvider;
use BitApps\Pi\src\Interfaces\ActionInterface;

if (!\defined('ABSPATH')) {
    exit;
}

class ZohoProjectAction implements ActionInterface
{
    private NodeInfoProvider $nodeInfoProvider;

    private ZohoProjectService $zohoProjectService;

    public function __construct(NodeInfoProvider $nodeInfoProvider)
    {
        $this->nodeInfoProvider = $nodeInfoProvider;
    }

    public function execute(): array
    {
        $executedNodeAction = $this->executeZohoProjectAction();

        return Utility::formatResponseData(
            $executedNodeAction['status_code'],
            $executedNodeAction['payload'],
            $executedNodeAction['response']
        );
    }

    private function executeMachine($machineSlug, $fieldMapData, $configs)
    {
        $portalId = $configs['portal-id']['value'] ?? null;
        $projectId = $configs['project-id']['value'] ?? null;
        $milestoneId = $configs['milestone-id']['value'] ?? null;

        switch ($machineSlug) {
            case 'createProject':
                return $this->zohoProjectService->createProject($fieldMapData, $portalId);

            case 'updateProject':
                return $this->zohoProjectService->updateProject($fieldMapData, $portalId, $projectId);

            case 'deleteProject':
                return $this->zohoProjectService->deleteProject($portalId, $projectId);

            case 'createTasklist':
                return $this->zohoProjectService->createTasklist($fieldMapData, $portalId, $projectId, $milestoneId);

            case 'createMilestone':
                return $this->zohoProjectService->createMilestone($fieldMapData, $portalId, $projectId);

            case 'createTask':
                return $this->zohoProjectService->createTask($fieldMapData, $portalId, $projectId);

            case 'listProjects':
                return $this->zohoProjectService->listProjects($portalId);
        }
    }

    private function executeZohoProjectAction()
    {
        $machineSlug = $this->nodeInfoProvider->getMachineSlug();
        $configs = $this->nodeInfoProvider->getFieldMapConfigs();
        $fieldMapData = $this->nodeInfoProvider->getFieldMapData();

        $authorizationHandler = AuthorizationFactory::getAuthorizationHandler(
            AuthorizationType::OAUTH2,
            $configs['connection-id']
        );

        $connection = $authorizationHandler->getConnection();
        $domain = $connection->auth_details->extraData->domain ?? 'com';
        $accessToken = $authorizationHandler->getAccessToken();
        $authHeader = str_replace('Bearer ', 'Zoho-oauthtoken ', $accessToken);

        $headers = [
            'content-type'  => 'application/json',
            'Authorization' => $authHeader,
        ];

        $this->zohoProjectService = new ZohoProjectService($headers, $domain);

        return $this->executeMachine($machineSlug, $fieldMapData, $configs);
    }
}
